<?php

namespace DML\MainVisBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class DefaultController extends Controller
{
    /**
     * @Route("/", name="default_index")
     * @Template()
     *
     * expected GET params
     *      api2                [client+server] switches to an alternative api
     *      jasmine             [client+server] enables jasmine
     *      no_data_caching     [client] appends "random" to all API requests
     *      show_assets_version [client] shows a coloured box with assets version (helps see changes in css / js) ='
     *      show_raw_data       [client] populates vis instances with raw data
     */
    public function indexAction()
    {
        $alternativeApiRootPaths = array('//mirg.city.ac.uk/co/api/'); // array('//lewes.nsqdc.city.ac.uk:4060/cp/api/')
        $defaultApiRootPaths = array('//mirg.city.ac.uk/cp/api/');
        $swapAPIs = strpos($this->get('request')->getHttpHost(), 'mirg') !== false;

        if ($swapAPIs) {
            $bubble = $defaultApiRootPaths;
            $defaultApiRootPaths = $alternativeApiRootPaths;
            $alternativeApiRootPaths = $bubble;
        }

        return array (
            'enableJasmine' => $this->get('request')->query->has('jasmine'), // JS behaviour tests powered by jasmine.js
            //'enableJasmine' => true,
            'musicLibrary' => array(
                'dataVersion' => 2,
                'dataCaching' => !$this->get('request')->query->has('no_data_caching'),
                //'apiRootPaths' => array('http://mirg.city.ac.uk/dmlapi/api/'),
                //'apiRootPaths' => array('//lewes.nsqdc.city.ac.uk:3020/cp/api/'),
                'apiRootPaths' => $this->get('request')->query->has('api2')
                        ? $alternativeApiRootPaths
                        : $defaultApiRootPaths,
                'defaultApiRootPaths' => $defaultApiRootPaths,
                'apiVersion' => 4
            ),
            'project' => $this->container->getParameter('anonymous')
                ? array(
                    'shortTitle' => ' ◦◦◦',
                    'title' => 'Anonymous Project',
                    'anonymous' => false
                )
                : array(
                    'shortTitle' => 'DML',
                    'title' => 'Digital Music Lab',
                    'anonymous' => false
                )
        );
    }

    /**
     * @Route("/web/")
     * @Template()
     */
    public function redirectFromWebAction()
    {
        return $this->redirect($this->generateUrl("default_index"), 301);
    }

}
