"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    // Define private variables
    var logger = null;

    /**
     * Module initializer
     *
     */
    RepresentationModule.addInitializer(function(){

        logger = Logger.get("App.RepresentationModule");

        RepresentationModule.DynanicDerivedConfigDataProvider = Marionette.Object.extend({
            initialize: function() {
                this._dynamicDerivedConfigDataByConfigClientId = {};
                this._kindByConfigClientId = {};
            },

            get: function(config) {
                if (!config) {
                    return null;
                }
                var configClientId = config.getClientId();

                var configKind = config.getParameterValue("kind");
                if (this._kindByConfigClientId[configClientId] !== configKind) {
                    this.retire(configClientId);
                    this._kindByConfigClientId[configClientId] = configKind;
                }
                if (!this._dynamicDerivedConfigDataByConfigClientId[configClientId]) {
                    var master = App.RepresentationModule.getMasterForConfig(config);
                    var configGrid = this.options.configGridsByType[config.getConfigGridType()];
                    this._dynamicDerivedConfigDataByConfigClientId[configClientId] = master.generateDynamicDerivedConfigData(config, configGrid);
                }

                return this._dynamicDerivedConfigDataByConfigClientId[configClientId];
            },

            retire: function (configClientId) {
                var dynamicDerivedDataToRetire = this._dynamicDerivedConfigDataByConfigClientId[configClientId];
                if (dynamicDerivedDataToRetire) {
                    dynamicDerivedDataToRetire.destroy();
                }
                delete this._dynamicDerivedConfigDataByConfigClientId[configClientId];
                delete this._kindByConfigClientId[configClientId];
            },

        });
    });
}, Logger);
