"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.Error = Marionette.Object.extend({
            defaults: {
                type: "unknown"
            },

            knownErrorTypes: {
                    "drawing":                       {needToEmptyContent: true},
                    "view_default":                  {needToEmptyContent: true},
                    "view_unknown":                  {needToEmptyContent: true},

                    "data-preparing_entity-derived": {needToEmptyContent: false},
                    "data-preparing_base":           {needToEmptyContent: false},
                    "data-preparing_overlay":        {needToEmptyContent: false},

                    "api-error_entity-derived":      {needToEmptyContent: true},
                    "api-error_base":                {needToEmptyContent: true},
                    "api-error_overlay":             {needToEmptyContent: true},

                    "api-message_progress_base":     {needToEmptyContent: true},

                    "data-error_entity-config":      {needToEmptyContent: true},
                    "data-error_view-config":        {needToEmptyContent: true},
                    "data-error_entity-derived":     {needToEmptyContent: true},
                    "data-error_base":               {needToEmptyContent: true},
                    "data-error_overlay":            {needToEmptyContent: true},

                    "collection_undefined":          {needToEmptyContent: true},
                    "collection_no-recordings":      {needToEmptyContent: true},
                    "pair_incomplete":               {needToEmptyContent: true},
                    "comparison_not-supported":      {needToEmptyContent: true},
                    "comparison_wrong-type":         {needToEmptyContent: true},
                    "recording_undefined":           {needToEmptyContent: true},
                    "ok-count-0":                    {needToEmptyContent: true},

                    "auxiliary-resources_pending":   {needToEmptyContent: false},
                    "auxiliary-resources_fail":      {needToEmptyContent: true},

                    "unknown":                       {needToEmptyContent: true}
            },

            initialize: function(options) {
                this.options = _.defaults(options, this.defaults);
            },

            needToEmptyContent: function() {
                return this.knownErrorTypes[this.options.type].needToEmptyContent;
            }
        });
        RepresentationModule.Error.protot
    });
}, Logger);
