(function() {
/**
 * centroid function in vega expression
 */
if (vg) {
    var Transform = vg.transforms.bin.prototype.__proto__.constructor;

    function Centroid(graph) {
        Transform.prototype.init.call(this, graph);
        Transform.addParameters(this, {
            field: {type: 'field'}
        });

        this._output = {centroid_x: 'centroid_x', centroid_y: 'centroid_y'};
        return this.mutates(true);
      }

      var prototype = (Centroid.prototype = Object.create(Transform.prototype));
      prototype.constructor = Centroid;

      prototype.transform = function(input) {
        //log.debug(input, ['generating a centroid']);

        var output_x  = this._output.centroid_x,
            output_y  = this._output.centroid_y,
            get = this.param('path').accessor;

        var svg = d3.select("body").append("svg")
            //.remove()
            .attr("width", 400)
            .attr("height", 400);

        var p = svg.append("path");
        function update(d) {
            p.attr("d", d["layout_path"]);
            var bbox = p.node().getBBox();
            var x = Math.floor(bbox.x + bbox.width/2.0);
            var y = Math.floor(bbox.y + bbox.height/2.0);
            vg.dataflow.Tuple.set(d, output_x, x);
            vg.dataflow.Tuple.set(d, output_y, y);
        }
        input.add.forEach(update);
        input.mod.forEach(update);
        input.rem.forEach(update);

        input.fields[output_x] = 0;
        input.fields[output_y] = 0;
        return input;
      };

      //module.exports = Bin;

      Centroid.schema = {
        "$schema": "http://json-schema.org/draft-04/schema#",
        "title": "Bin transform",
        "description": "Bins values into quantitative bins (e.g., for a histogram).",
        "type": "object",
        "properties": {
          "type": {"enum": ["bin"]},
          "field": {
            "oneOf": [{"type": "string"}, {"$ref": "#/refs/signal"}],
            "description": "The name of the field to calculate centroids from values from."
          },
          "output": {
            "type": "object",
            "description": "Rename the output data fields",
            "properties": {
              "bin": {"type": "string", "default": "bin"}
            },
            "additionalProperties": false
          }
        },
        "additionalProperties": false,
        "required":["field"]
      };

    vg.transforms.centroid = Centroid;
    console.log(vg);
} else {
    //console.error("Can't register centroid filter in vega expression");
}
}());