"use strict";

App.module("MainRegionModule", function (MainRegionModule, App, Backbone, Marionette, $, _, Logger) {

    MainRegionModule.ConfigHeaderView = MainRegionModule.ConfigGridChildView.extend({

        options: {
            dimension: null,
            parentState: null,
            configGrid: null,
            config: null,
            parentConfigGridView: null,
        },

        _dimensionIsEntity: false,
        _dimensionIsView: false,

        initialize: function(options) {
            var _this = this;

            _this.options = _.defaults(options || {}, _this.options);

            _this._cachedConfigGridType = options.configGrid.getType();
            _this._cachedKind = "-";
            _this._cachedMaster = null;

            _this.$el.disableSelection();

            _this.dynamicDerivedConfigData = null;

            if (_this.options.dimension === "entity") {
                _this._dimensionIsEntity = true;
            } else {
                _this._dimensionIsView = true;
            }

//            _this._debouncedRenderIfParentConfigGridIsVisible = _.debounce(function() {
//                _this.renderIfParentConfigGridIsVisible();
//            }, 50);
            _this._debouncedRenderIfParentConfigGridIsVisible = _this.renderIfParentConfigGridIsVisible;

            _this.listenTo(_this.options.configGrid, "change_selection", _this._debouncedRenderIfParentConfigGridIsVisible);
            _this.listenTo(_this.options.configGrid, "change_layout",    _this._debouncedRenderIfParentConfigGridIsVisible);
            _this.listenTo(_this.options.config,     "change:parametersOrPlannedParameterUpdates", _this._debouncedRenderIfParentConfigGridIsVisible);

            _this._$background  = $.bem.generateElement("config-grid-cells", _this._dimensionIsEntity ? "entity-header-background" : "view-header-background");
            _this.$el.append(_this._$background);

            _this.$el.click(function(event) {
                if (_this._dimensionIsEntity) {
                    _this.options.parentConfigGridView.ignoreAxisOnNextScroll(false, true);
                } else {
                    _this.options.parentConfigGridView.ignoreAxisOnNextScroll(true, false);
                }
                if (_this._cachedSelected) {
                    _this.options.parentConfigGridView.scrollAccordingToSelection();
                } else {
                    _this.options.configGrid.set(_this._dimensionIsEntity ? "selectedEntityConfigClientId" : "selectedViewConfigClientId", _this.options.config.getClientId());
                }
                event.stopPropagation();
                event.preventDefault();
            });

            _this._cachedSelected = false;
            _this._cachedHashForParameters = null;
        },

        setSize: function (widthOrHeight) {
            var _this = this;

            var $el = _this.$el;
            var changed = false;
            if (_this._dimensionIsEntity) {
                if (widthOrHeight != $el.width()) {
                    $el.width(widthOrHeight);
                    changed = true;
                }
            } else {
                return;
                if (widthOrHeight != $el.height()) {
                    $el.height(widthOrHeight);
                    changed = true;
                }
            }

            if (changed) {
                _this._debouncedRenderIfParentConfigGridIsVisible();
            }
        },

        render: function (deep, instant) {
            var _this = this;

            // do not render if config has just been removed from the grid,
            // but the view has not been destroyed yet
            if (!_this.options.config.getConfigGridType()) {
                return;
            }

            // modifier: selected or not
            var newSelected = _this._dimensionIsEntity
                   ? _this.options.configGrid.getSelectedEntityConfig() == _this.options.config
                   : _this.options.configGrid.getSelectedViewConfig()   == _this.options.config;

            if (newSelected !== _this._cachedSelected) {
                if (newSelected) {
                    _this.$el.addClass(_this._dimensionIsEntity ? "config-grid-cells__entity-header_selected" : "config-grid-cells__view-header_selected");
                } else {
                    _this.$el.removeClass(_this._dimensionIsEntity ? "config-grid-cells__entity-header_selected" : "config-grid-cells__view-header_selected");
                }
                _this._cachedSelected = newSelected;
            };

            // kind
            var newKind = _this.options.config.getParameterValue("kind");
            if (newKind !== _this._cachedKind) {
                _this._cachedKind = newKind;
                _this._cachedMaster = App.RepresentationModule.getMasterForConfig(_this.options.config);

                // swap derived config data when the kind changes (i.e. the master changes)
                if (_this.dynamicDerivedConfigData) {
                    _this.stopListening(_this.dynamicDerivedConfigData);
                }
                _this.dynamicDerivedConfigData = App.dynamicDerivedConfigDataProvider.get(_this.options.config);
                _this.listenTo(_this.dynamicDerivedConfigData, "change", _this._debouncedRenderIfParentConfigGridIsVisible);

                _this.$el.setMod("config-grid-cells", "entity-header", "kind", newKind ? newKind : false);
            }

            // content
            _this._cachedMaster.renderHeaderContent(this, instant);
        },
    });
}, Logger);