"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view._histogram",
            inherit: "view._",

            options: {
                canHaveBase: true,

                visInstanceContentHeightMin: 50,
                visInstanceContentHeightMax: 1000,

                visInstanceSupportedComparisonModes: ["superposition", "direct"],
            },


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _doRenderVisInstanceViewBaseWithKnownComparisonMode: function(visInstanceView, comparisonMode) {
                var options = this._generateHistogramOptions(_.str.trim(visInstanceView.options.viewConfig.getParameterValue("kind")));
                options.comparisonMode = comparisonMode;

                App.GraphicsRenderingModule.render("histogram", visInstanceView.$content, this._groupDataForGraphicsRendering(visInstanceView, "base"), options);
            },

            _generateHistogramOptions: function(pid) {}
         });
    });
}, Logger);
