"use strict";

App.addInitializer(function(options){

    var $document = $(document);


    var cid = 0;
    var uniqueClientId = function() {
        return "custom" + cid++;
    };

    var nextUniqueClientId = function() {
        return "custom" + cid;
    };

    // Resetting a default state
    $document.bind("keydown", "shift+0", function(event) {
        App.context.get("state").unserialize(App.contextManager.defaultSerializedAppContexts[""].stateHistory.currentSerializedState);
    });

    var sharedMusicRecordingConfig = {
        "viewConfigs": [
                        {clientId: "def4", parameters: {kind: "properties"}},
                        {clientId: "def5", parameters: {kind: "midi-pitch-histogram"}},
                    ],
                };

    // Moving to a specific state
    $document.bind("keydown", "shift+1", function(event) {
        App.context.get("state").unserialize({
            //"musicRecordingsGridIsShown": App.context.get("state").get("musicRecordingsGridIsShown"),
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl", composer: "Haydn", performer: "Karajan", year: "1959", title: "Symphonies;104"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "tuning-stats"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });


    $document.bind("keydown", "shift+2", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", composer: "Haydn", title: "Symphony"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "tuning-stats"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });

    $document.bind("keydown", "shift+3", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", year: "1940-1979", title: "Symphony"}},
                    {clientId: uniqueClientId(), parameters: {kind: "pair", "comparisonMode": "superposition"}},
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", year: "1980-2010", title: "Symphony"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "tuning-stats"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });

    $document.bind("keydown", "shift+4", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", composer: "Schoenberg"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "midi-pitch-histogram"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });


    $document.bind("keydown", "shift+5", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl", collection: "dinka"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "pitch-histogram"}},
                    {clientId: uniqueClientId(), parameters: {kind: "midi-pitch-histogram"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });

    $document.bind("keydown", "shift+6", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", composer: "Chopin", title: "Mazurka;Op.68;no.2"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "mean-tempo-curve"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });



    $document.bind("keydown", "shift+7", function(event) {
        App.context.get("state").unserialize({
            "musicCollectionGrid": {
                "selectedEntityConfigClientId": nextUniqueClientId(),
                "entityConfigs": [
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", composer: "Chopin", title: "Mazurka;Op.68;no.2"}},
                    {clientId: uniqueClientId(), parameters: {library: "bl;charm", composer: "Chopin"}},
                    ],
                "viewConfigs": [
                    {clientId: uniqueClientId(), parameters: {kind: "list"}},
                    {clientId: uniqueClientId(), parameters: {kind: "mean-tempo-curve"}},
                ],
            },
            "musicRecordingGrid": sharedMusicRecordingConfig
        });
    });
});
