"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection.midi-pitch-histogram",
            inherit: "view.collection._histogram",

            defaultConfigParameterValues: {
                weighting: "none"
            },


            // =================================================================
            // vis instance rendering


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var result = {
                        "weighting":   this.getConfigParameterValueOrDefaultValue(viewConfig, "weighting", true),
                    };
                return result;
            },
        });
    });
}, Logger);
