"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection._similarity",
            inherit: "view._default",

            options: {
                canHaveBase: true,
                widthToHeightRatio: 1,
                headerSuffixesForCompressorValues: {
                    "zlib": "normalised",
                    "zxd":  "differential"
                },
            },

            defaultConfigParameterValues: {
                measure:                       "euclidean",
                simFeaturesIncludeChords:      "1",
                simFeaturesIncludeChromagram:  "1",
                simFeaturesIncludeMFCC:        "1",
                compressor:                    "zlib",
                subsampling:                   "1"
            },


            // =================================================================
            // housekeeping

            _listSimFeatures: function(viewConfig) {
                var result = [];
                if (this.getConfigPlannedParameterValueOrDefaultValue(viewConfig, "simFeaturesIncludeChords")) {
                    result.push("chords");
                }
                if (this.getConfigPlannedParameterValueOrDefaultValue(viewConfig, "simFeaturesIncludeChromagram")) {
                    result.push("chromagram");
                }
                if (this.getConfigPlannedParameterValueOrDefaultValue(viewConfig, "simFeaturesIncludeMFCC")) {
                    result.push("mfcc");
                }
                return result;
            },


            // =================================================================
            // config grid panel


            // -----------------------------------------------------------------
            // config grid panel - prepare

            prepareConfigGridPanelMainArea: function(configGridPanelView) {
                configGridPanelView._$mainArea.data("$measure", configGridPanelView._$mainArea.find(".cgpma__id_compressor"));
                configGridPanelView._$mainArea.data("$subsampling",  configGridPanelView._$mainArea.find(".cgpma__id_subsampling"));

                // Parent master's behaviour
                RepresentationModule.getMasterById("view._default").prepareConfigGridPanelMainArea.apply(this, arguments);
            },


            // -----------------------------------------------------------------
            // config grid panel - sync

            syncConfigGridPanelMainArea: function(configGridPanelView, instant) {
                var measure = this.getConfigPlannedParameterValueOrDefaultValue(configGridPanelView._cachedConfig, "measure").toLowerCase().trim();
                var toggleValue = measure == "compression";
                configGridPanelView._$mainArea.data("$measure").toggle(toggleValue);
                configGridPanelView._$mainArea.data("$subsampling").toggle(toggleValue);

                // Parent master's behaviour
                RepresentationModule.getMasterById("view._default").syncConfigGridPanelMainArea.apply(this, arguments);
            },


            // =================================================================
            // config grid header

            _generateHeaderLabelSuffix: function(headerView) {
                var result = [" ("];

                var simFeatures = this._listSimFeatures(headerView.options.config);
                if (simFeatures) {
                    result.push("by ");
                    result.push(simFeatures.join(" + "));
                } else {
                    result.push("no characteristics");
                }

                var measure  =  this.getConfigParameterValueOrDefaultValue(headerView.options.config, "measure", true);
                if (measure == "euclidean") {
                    result.push("; euclidean measure");
                } else if (measure == "compression") {
                    var compressor  =   this.getConfigParameterValueOrDefaultValue(headerView.options.config, "compressor", true);
                    var compressorLabel = this.options.headerSuffixesForCompressorValues[compressor];
                    if (compressorLabel) {
                        result.push(_.str.sprintf("; %s compressor", compressorLabel));
                    } else {
                        result.push("; unknown compressor");
                    };
                    var subsampling = this.getConfigParameterValueOrDefaultValue(headerView.options.config, "subsampling", true);
                    if (subsampling) {
                        result.push("; subsampling");
                    }
                } else {
                    result.push("; unknown measure");
                }
                result.push(")");
                return result.join("");
            },


            // =================================================================
            // vis instance rendering

            calculateVisInstanceContentHeight: function(viewConfig, entityWidth) {
                var representation = this.getConfigParameterValueOrDefaultValue(viewConfig, "representaton", true);
                return entityWidth;
            },


            // -----------------------------------------------------------------
            // vis instance rendering - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                var measure = this.getConfigParameterValueOrDefaultValue(viewConfig, "measure", true);
                var result = {
                        "sim_features": this._listSimFeatures(viewConfig).join(","),
                        "sim_type":     measure,
                        "pid":          "similarity"
                    };
                if (measure) {
                    result["sim_compressor"] = this.getConfigParameterValueOrDefaultValue(viewConfig, "compressor", true);
                    result["sim_downsample"] = this.getConfigParameterValueOrDefaultValue(viewConfig, "subsampling", true);
                }
                return result;
            },


            _doRenderVisInstanceViewBaseWithKnownComparisonMode: function(visInstanceView, comparisonMode) {
                var viewConfig = visInstanceView.options.viewConfig;

                var options = {};
                options.comparisonMode = comparisonMode;

                options.measure = !!this.getConfigParameterValueOrDefaultValue(viewConfig, "measure", true);

                options.primaryColor = "#3182bd";
                options.secondaryColor = "#31a354";

                var representation = this.getConfigParameterValueOrDefaultValue(viewConfig, "sequenceRepresentation", true);
                App.GraphicsRenderingModule.render(this.id.split(".")[2], visInstanceView.$content, this._groupDataForGraphicsRendering(visInstanceView, "base"), options);
            },

        });
    });
}, Logger);
