"use strict";

App.module("RepresentationModule", function(RepresentationModule, App, Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options){

        RepresentationModule.registerMaster({
            id: "view.collection._histogram",
            inherit: "view._histogram",

            options: {
            },


            // =================================================================
            // dynamic derived vis instance data


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - base


            // =================================================================
            // vis instance rendering

            _generateHistogramOptions: function(pid) {
                var options = {};
                options.colorForBars = "#3182bd";
                options.colorForOverlay = "#31a354";

                options.dataDefinition = {};
                options.dataDefinition.forXs = null;
                options.dataDefinition.forBars = null;
                options.dataDefinition.forFlats = null;

                switch (pid) {
                case "tempo-histogram":
                case "pitch-histogram":
                    options.dataDefinition.forXs = "edges";
                    options.dataDefinition.forBars = "counts";
                    break;
                case "midi-pitch-histogram":
                    options.dataDefinition.forXs = "values";
                    options.dataDefinition.forBars = "counts";
                    break;
                case "mean-tempo-curve":
                    options.dataDefinition.forXs = function(data){return _.range(0, data.means.length);};
                    options.dataDefinition.forBars = "means";
                    options.dataDefinition.forFlats = "std_devs";
                    break;
                case "tuning-stats":
                    options.dataDefinition.forXs = function(data){return data.stats.hist.edges;};
                    options.dataDefinition.forBars = function(data){return data.stats.hist.counts;};
                    options.dataDefinition.forXMean = function(data){return data.stats.mean;};
                    options.dataDefinition.forXStdDev = function(data){return data.stats["std-dev"];};
                    break;
                case "tonic-histogram":
                    options.dataDefinition.forXs = "values";
                    options.dataDefinition.forBars = "counts";
                    break;
                case "pitch-class-histogram":
                case "tonic-relative-pitch-class-histogram":
                    options.dataDefinition.forXs = "values";
                    options.dataDefinition.forBars = "counts";
                    break;
                }
                return options;
            }
        });
    });
}, Logger);
