"use strict";

App.module("RepresentationModule", function(RepresentationModule, App,
        Backbone, Marionette, $, _, Logger) {

    RepresentationModule.addInitializer(function(options) {

        RepresentationModule.registerMaster({
            id : "view._unknown",
            inherit : "view._",

            options : {
                visInstanceContentHeightMin : 20,
                visInstanceContentHeightMax : 20,
            },

            defaultConfigParameterValues: {
                widthToHeightRatio: undefined
            },


            // =================================================================
            // config grid header

            _generateHeaderLabelSuffix : function(headerView) {
                return " (unknown feature)";
            },


            // =================================================================
            // dynamic derived vis instance data


            // -----------------------------------------------------------------
            // dynamic derived vis instance data - base

            _generateCustomParamsForBasePerspectiveRequestParams: function(viewConfig) {
                return null;
            },

        });
    });
}, Logger);
