"use strict";

App.module("GraphicsRenderingModule", function(GraphicsRenderingModule, App, Backbone, Marionette, $, _, Logger) {

    GraphicsRenderingModule.addInitializer(function(options){

        GraphicsRenderingModule.registerRenderer({
            id: "_",

            defaultVegaConfig: {
                colorForBackground:     "#fff",
                colorForAxisLabels:     "#999",
                colorForAxes:           "#ccc",
                colorForBackgroundFill: "#f0f0f0",
                fontFace: "'Web Open Sans', Verdana, sans-serif",
                fontSize: 10,
                fontSizeForLabelsInAxis: 10,
                fontSizeForLabelsInSecondaryAxis: 8,

                data:   [],
                scales: [],
                axes:   [],
                marks:  [],
                // these are used for debugging (easy to make stuff invisible to test if things work without it)
                xdata:   [],
                xscales: [],
                xaxes:   [],
                xmarks:  []
            },

            render: function($element, data, options) {

                // vc stands for vega config
                // FIXME proper deep clone is needed
                var vc = _.mapObject(this.defaultVegaConfig, _.clone);

                vc = _.extend(vc, options);

                vc.totalWidth   = $element.width();
                vc.totalHeight  = $element.height();

                this._formVC(vc, data);

                var vegaSpec = {
                        "background": vc.colorForBackground,
                        "width":   vc.width,
                        "height":  vc.height,
                        "padding": vc.padding,
                        "data":    vc.data,
                        "scales":  vc.scales,
                        "axes":    vc.axes,
                        "marks":   vc.marks
                    };

                var $cover = $.bem.generateElement("vis-instance", "cover", ["category_process", "visible"]);
                var $coverMessage = $.bem.generateElement("vis-instance", "cover-message").text("Drawing...");
                $cover.append($coverMessage);
                $element.append($cover);
                GraphicsRenderingModule.vegaAsync($element, vegaSpec, "svg");
            },

            _formVC: function(vc, data, options) {},
        });
    });
}, Logger);
