"use strict";

App.module("DataModule", function(DataModule, App, Backbone, Marionette, $, _, Logger) {
    // Prevent auto start
    //CollectionDefinitionProvider.startWithParent = false;

    // Define private variables
    var logger = null;

    /**
     * Module initializer
     * 
     */
    DataModule.addInitializer(function(){

        logger = Logger.get("App.DataModule");

        DataModule.DynamicDefinitionForRecording = DataModule.DynamicDefinition.extend({});
        DataModule.DymanicDefinitionProviderForRecordings = DataModule.DynamicDefinitionProvider.extend({
            
            options: {
                DynamicDefinition:                 DataModule.DynamicDefinitionForRecording,
                apiMethod:                         "getRecordingPerspective",
                customAttributesWhenNotApplicable: {label: undefined},
                customAttributesWhileBeingUpdated: {label: null},
                customAttributesWhenFaulty:        {label: false}
            },
            
            isFaulty: function(dynamicDefinition) {
                return dynamicDefinition.attributes.label === false;
            },

            isBeingUpdated: function(dynamicDefinition) {
                return dynamicDefinition.attributes.label === null;
            },
            
            configParametersToRequestParameters: function(config) {
                var rawConfigParameters = config.attributes.parameters.attributes;
                if (rawConfigParameters.recordingURI) {
                    return {"uri": rawConfigParameters.recordingURI, "pid": "properties"};
                } else {
                    return null;
                }
            },
            
            apiResponseToAttributes: function(data, query) {
                var attributes = {};
                
                if (data && data.label) {
                    attributes = data;
                } else {
                    attributes = {label: false};
                    if (data.errors) {
                        attributes = _.clone(this.options.customAttributesWhenFaulty)
                        attributes.errors = data.errors;
                    }
                    logger.warn("An error occured when attempting to obtain new recording definition. Query / response:", query, data);
                };
                attributes.query = query;
                return attributes;
            }
        });
    });
}, Logger);
