function dml_paperfig(fig,fn,fs,lw,colour,ms,lwr)
% dml_paperfig(fontname)
% dml_paperfig(fontname, fontsize)
% dml_paperfig(fontname, fontsize, linewidth)
% dml_paperfig(fontname::string, fontsize::natural, linewidth::nonneg, colour::bool)
% dml_paperfig :: 
%    string/'Times' ~'font name',
%    natural/9      ~'font size',
%    nonneg/0.4     ~'line width', 
%    bool/1         ~'colour or b/w',
%    nonneg/4       ~'marker size'
% -> action handle.
%
% Sets up default linewidth and hardcopy inversion
% for printing to white paper at  high resolution.
% also, sets to white background. Optional font name
% to used for labels etc.

figure(fig);
clf;
h=gcf;
whitebg(h,'w');
set(h,'Color','w');
set(h,'DefaultTextFontSize',fs);
set(h,'DefaultTextFontName',fn);
set(h,'DefaultAxesFontSize',fs);
set(h,'DefaultAxesFontName',fn);
set(h,'DefaultAxesLineWidth',lwr*lw);
set(h,'DefaultTextColor','k');
set(h,'DefaultLineLineWidth',lw);
set(h,'DefaultLineMarkerSize',ms);
set(h,'InvertHardcopy','off');
if ~colour,
	set(h,'DefaultAxesColorOrder',[0 0 0]);
	set(h,'DefaultAxesLineStyleOrder','-|:|--|-.');
end
