/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University College London
	Distributed under GPL v3
*/
function load_img(id,url)
{
   var xhr = new XMLHttpRequest();
   xhr.open('GET',url,true);
   xhr.responseType = 'arraybuffer';
   xhr.onload = function(e) {
      var type = xhr.getResponseHeader('Content-Type')
      console.log(type)

      var arr = new Uint8Array(this.response);
      var raw = '';
      var i,j,subArray,chunk = 5000;
      for (i=0,j=arr.length; i<j; i+=chunk) {
         subArray = arr.subarray(i,i+chunk);
         raw += String.fromCharCode.apply(null, subArray);
      }
      var dataURL="data:"+type+";base64,"+btoa(raw);
      document.getElementById(id).src = dataURL;
   };
   xhr.send();
}

function load_img2(id,url)
{
   var xhr = new XMLHttpRequest();
   xhr.responseType = 'arraybuffer';
   xhr.onload = function() {
      var type = xhr.getResponseHeader('Content-Type')
      var el = document.getElementById(id);
      if (type.substring(0,6)=="image/") {
         var blb = new Blob([xhr.response], {type: type});
         var url = (window.URL || window.webkitURL).createObjectURL(blb);
         el.src = url;
      } else { 
         var styles = window.getComputedStyle(el);
         var fr = document.createElement('iframe');
         var st = fr.style;
         st.width=styles.getPropertyValue('width');
         st.height=styles.getPropertyValue('height');
         st.display='inline';
         st['vertical-align']='middle';
         st['background-color']='#ffe0e0';

         el.parentNode.replaceChild(fr, el);
         var arr = new Uint8Array(this.response);
         var raw = String.fromCharCode.apply(null, arr);
         var doc = fr.contentWindow.document;
         doc.open();
         doc.write(raw);
         doc.close();
         doc.body.style['font-size']='80%'
      }
   }
   xhr.open('GET',url);
   xhr.send();
}

