/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University College London
	Distributed under GPL v3
*/

function init_playlist(id){
   var audio=$('#'+id+'-audio');
   var tracks=$('#'+id+'-list').find('li a.audio');
   var current=0;

   console.log('Initialising playlist '+id+' with '+tracks.length+' tracks.');
   last=tracks.length - 1;
   audio[0].volume= .50;
   tracks.click(function(e){
     e.preventDefault();
     link=$(this);
     current=link.parent().parent().index();
     pl_run(link, audio[0]);
   });
   audio[0].addEventListener('ended',function(e){
     current++;
     if(current==last){current=0; link=tracks[0];}
     else{link=tracks[current];}
     pl_run($(link),audio[0]);
   });
}
function pl_run(link, player){
  player.src=link.attr('href');
  par=link.parent().parent();
  par.addClass('active').siblings().removeClass('active');
  player.load();
  player.play();
}
