/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University College London
	Distributed under GPL v3
*/

/* clears the graph display element */
function clear_output() { $('#output').html(''); } 

/* Following are three different ways to load a pan/zoom enabled SVG 
 * element into the #output element. */

/* USING JQUERY: loads SVG content from a URL into an element identified 
 * by a jQuery selector. Pan/Zoom controls are then enabled for the SVG element. */
function load_svg(sel,url) {
   target=$(sel);
   target.load(url, function () {
      console.log("SVG loaded");
      svg=target.find('svg');
      svg.attr('width','100%').attr('height','100%');
      svgPanZoom(svg.get(0),{
             zoomEnabled: true,
             controlIconsEnabled: true,
             fit: true,
             center: true
           });
   });
}

/* USING OBJECT element. No good. */
function load_object(sel,url) {
   console.log(url);
   var obj=$('<object id="obj" width="100%" height="100%" type="image/svg+xml" data="'+url+'"></object>');
   $('#output').html(obj);
   // cannot get hold of SVG element here for some reason...
   // var svg=obj.get(0).contentDocument.getElementsByTagName('svg')[0];
}

/* Using SVG element with xlink:href attribute to link to content 
 * This does not seem so good for some reason... */
function load_svg_href(sel,url) {
   var svg=$('<svg id="svg" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><image x="0" y="0" width="100%" height="100%" xlink:href="'+url+'"></image></svg>');
   sel.html(svg);
   svgPanZoom('#svg',{
          zoomEnabled: true,
          controlIconsEnabled: true,
          fit: true,
          center: true
        });
}

/* Gets module name from #module and loads callgraph into #output */
function update_svg(loc) {
   var module=$('#module').val();
   load_svg('#output',loc+"?format=svg&module="+module);
}
