/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(pure, []).

/** <module> Enables use of Pure CSS framework
*/

%  http://yui.github.io/skinbuilder/?mode=pureindex.html?opt=swi,457387,ffffff,1,1,20,1.5&h=0,-30,60&n=0,-30,75&l=0,-30,80&b=0,-30,90&mode=pure")
%
:- use_module(library(http/http_path)).
:- use_module(library(http/html_write)).
:- use_module(library(http/html_head)).
:- use_module(library(http/js_write)).
:- use_module(library(htmlutils)).

:- set_prolog_flag(double_quotes,string).

/*
   YUI3 over HTTPS is just not going to work.
   Google provide YUI2, but not YUI3.
   
*/
http:location(yuix,"http://yui.yahooapis.com",[]).
http:location(pure,yuix('pure/0.5.0'),[]).
http:location(purecss,"//purecss.io/combo/1.16.5?",[]).

:- html_resource(purecss("css/layouts/side-menu.css"), [requires(pure("pure.min.css"))]).
:- html_resource(css("pure/pure-skin.css"), [requires(pure("pure-min.css"))]).

user:head(pure(_,_),Head) --> !,
   html(head([ \style("//yui.yahooapis.com/pure/0.5.0/pure-min.css")
             , \style("//yui.yahooapis.com/pure/0.5.0/grids-responsive-min.css")
             , \style("/css/pure/pure-skin.css")
             , meta([name(viewport), content("width-device-width,initial-scale=1")]) 
             | Head ])).

activate_dropdowns(DivId,ULId) -->
   {http_absolute_location(yuix('combo?'),ComboBase,[])},
   html_requires(yuix('3.17.2/build/yui/yui-min.js')),
   js_script({|javascript(ComboBase,DivId,ULId)||
      YUI({ classNamePrefix: 'pure', combine: true, comboBase: ComboBase 
          }).use('gallery-sm-menu', function (Y) {
        var horizontalMenu = new Y.Menu({
           container         : "#"+DivId,
           sourceNode        : "#"+ULId,
           orientation       : 'horizontal',
           hideOnOutsideClick: false,
           hideOnClick       : false,
           showdelay         : 125,
        });
        horizontalMenu.render();
        horizontalMenu.show();
      });|}
      ).

user:body(pure(1,Nav),Body) --> !,
   { setting(htmlutils:appname, AppName) },
	html(body([ div([id("layout"),class("pure-g")]
             , [ div(class("pure-u-1-4"), \vmenu(AppName,Nav))
               , div(class("content pure-u-3-4"), [
                   div(class(content),Body)
                 , div(class(footer),\hmenu(AppName,Nav))
                 ])
               ])
             ])).

user:body(pure(2,Nav),Body) --> !,
   { setting(htmlutils:appname, AppName) },

   use_font("Source Sans Pro",sourcepro),
   % use_font("Open Sans",opensans),
   % use_font("Quattrocento Sans",quattrocento),
   % html_requires(purecss("css/main-grid.css&/css/main.css&/css/menus.css&/css/rainbow/baby-blue.css")),
   html_requires(purecss("css/layouts/side-menu.css")),
	html(body(div(id(layout), 
             [ a([href="#menu", id="menuLink", class="menu-link"],span([]))
             , div(id(menu),\vmenu(AppName,Nav))
             , div(id(main),
               [ div(class(header), h1("Header"))
               , div(class(content), [div(Body),div(class=footer,\hmenu(AppName,Nav))])
               ])
             , \script(purecss("js/ui.js"))
             ]))).

button_link(Ref,Content) --> 
   html(a([class(['pure-button','pure-button-primary']),href(Ref)],Content)).

menu(Classes,Content) --> 
   html(div(class(['pure-menu', 'pure-menu-open'|Classes]), Content)).
% Add pure-menu-selected to active item
hmenu(Heading,Items) --> 
   menu(['pure-menu-horizontal'], [a([href='.',class="pure-menu-heading"],Heading), \Items]).

vmenu(Heading,Items) --> 
   menu([], [a([href='.',class="pure-menu-heading"],Heading), \Items]).

hmenu_with_dropdowns(Items) --> 
   % html_requires("//yui.yahooapis.com/3.17.2/build/yui/yui-min.js"),
   html_requires(css("pure/pure-skin.css")),
   {gensym(div,DivID), gensym(ul,ULID)},
   html(div(id=DivID,ul(id=ULID,\Items))),
   activate_dropdowns(DivID,ULID).
