/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(xmltraverse, [traverse/3, op(720,xfx,@), op(750,xfy,~), op(750,xfy,..) ]).
% for traverse/3 paths
:- op(720,xfx,@).
:- op(750,xfy,~).
:- op(750,xfy,..).

%% traverse(+Dir:oneof([f,b]), +Doc:xml_element, -P:xml_path) is nondet.
%
%  Succeeds once for each path through an XML element starting at the top
%  and travelling all or part of the way down through the tree structure.
traverse(f,El,Path) :- traverse_f(El,Path).
traverse(b,El,Path) :- traverse_b([],El,Path).

traverse_f(Other,{Other}) :- atomic(Other), !.
traverse_f(Element,\Element).
traverse_f(element(Name,_,_), n(Name)).
traverse_f(element(Name,Attribs,_),Name @ A) :- member(A,Attribs).
traverse_f(element(Name,_,Content),Name .. Path1) :- 
   (  Path1 = \Content
   ;  Path1 = (I~Path2),
      nth1(I,Content,SubE),
      traverse_f(SubE,Path2)
   ).


traverse_b(L,Other,{Other}..L) :- atomic(Other), !.
traverse_b(L,element(Name,Attribs,Content),Path) :- !,
   (  Path = (A @ Name .. L), member(A,Attribs)
   ;  nth1(N,Content,SubE),
      traverse_b(N ~ Name..L,SubE,Path)
   ).

