/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(stringutils, [ split_string_around/4, strip_string/2 ]).

split_string_around(Inter,String,Pre,Post) :-
   sub_string(String,Bef,_,Aft,Inter),
   sub_string(String,0,Bef,_,Pre1), strip_string(Pre1,Pre),
   sub_string(String,_,Aft,0,Post1), strip_string(Post1,Post).

strip_string(X,Y) :- split_string(X,"","\s",[Y]).

