/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(state, [set_state/2, get_state/2, with_state/3, retract_state/1]).

:- meta_predicate
      with_state(:,+,0),
      retract_state(:),
      set_state(:,+),
      get_state(:,-).

:- use_module(insist).
:- dynamic state/3.

get_state(M:Key,Value) :- state(M,Key,Value).
set_state(M:Key,Value) :-
   retractall(state(M,Key,_)),
   assert(state(M,Key,Value)).

with_state(M:Key,Value,Goal) :-
   insist(\+state(M,Key,_),state_exists(M:Key)),
   setup_call_cleanup( 
      assert(state(M,Key,Value)), Goal,
      retract_state(M:Key)).

retract_state(M:Key) :- retractall(state(M,Key,_)).


