/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(spotools,
      [  name_playlist/2
      ,  user_playlist/1
      ,  user_playlist/2
      ,  login/1
      ,  explicit/1
      ,  playlist_track/2
      ,  set_tracks/2
      ,  spotify/1
      ]).

:- use_module(library(dictutils)).
:- use_module(spotify).

:- dynamic current_app/1.

login(App) :- 
   spotify_authorise(App),
   writeln("Logged in as:"),
   retractall(current_app(_)),
   assert(current_app(App)),
   user(Me),
   print_dict(Me).

spotify(Goal) :- current_app(App), spotify(App,Goal).

user(Me) :- 
   current_app(App),
   spotify_user(App,Me).

name_playlist(Name,Playlist) :-
   user_playlist(Playlist),
   atom_string(Name,NameS),
   Playlist.name=NameS.

user_playlist(Playlist) :- 
   user(Me),
   user_playlist(Me,Playlist).

user_playlist(User,Playlist) :-
   spotify(playlists(User.id,Playlists)),
   member(Playlist,Playlists.items),
   tag(playlist,Playlist).

playlist_entry(PL,Entry) :-
   spotify(playlist_tracks(PL.owner.id,PL.id,Tracks)),
   member(Entry,Tracks.items),
   tag(track,Entry.track).

playlist_track(PL,Track) :-
   playlist_entry(PL,Entry),
   Track = Entry.track,
   maplist(tag(artist),Track.artists),
   tag(album,Track.album).

add_tracks(PL,Tracks) :-
   maplist(get_dict(uri),Tracks,URIs),
   spotify(add_tracks(PL.owner.id,PL.id,URIs)).

del_tracks(PL,Tracks) :-
   findall(_{uri:URI}, (member(T,Tracks),get_dict(uri,T,URI)), Ts),
   spotify(del_tracks(PL.owner.id,PL.id,_{tracks:Ts})).

clear_playlist(PL) :-
   findall(T,playlist_track(PL,T),Tracks),
   del_tracks(PL,Tracks).

set_tracks(PL,Tracks) :-
   maplist(get_dict(uri),Tracks,URIs),
   spotify(set_tracks(PL.owner.id,PL.id,URIs)).

set_playlist_tracks(Name,Tracks) :-
   atom_string(Name,NameS),
   name_playlist(NameS,PL), 
   spotify(set_tracks(PL.owner.id,PL.id,Tracks)).

explicit(Track) :- Track.explicit=true.


