/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(queries, 
      [  with_output_to_pengine/1
      ,  write_html/1
      ]).

:- use_module(library(pengines)).
:- use_module(library(http/html_write)).
:- use_module(library(apply_macros)).
:- use_module(library(dcg_core)).

sandbox:safe_primitive(html_write:print_html(_)).
sandbox:safe_primitive(flush_output).
sandbox:safe_meta(html_write:html(_,_,_),[]).

:- meta_predicate 
      with_output_to_pengine(0), 
      write_html(:).

with_output_to_pengine(Goal) :-
   with_output_to(atom(Reply), in_pre(Goal)),
      % catch( Goal, Ex, 
      %    in_pre((message_to_string(Ex,S),format(S))))),
   (Reply='' -> true; pengine_output(Reply)).

write_html(P) :-
   html(P,Toks,[]),
   print_html(Toks),
   flush_output.

