/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(pengutils, 
      [  write_html/1
      ,  term_rendering//3
      ]).

:- meta_predicate write_html(:).

:- use_module(library(http/html_write)).
:- use_module(library(pengines)).
:- use_module(library(sandbox)).
:- use_module(library(swish/render)).

:- register_renderer(html,"Render HTML").

:- meta_predicate write_html(:).
sandbox:safe_meta(pengutils:write_html(_),[]).

%% write_html(+HTML) is det.
%  Takes HTML elements as accepted by html//1 and outputs
%  them to the pengine.
write_html(M:H) :-
   debug(pengutils,'write_html(~w)',[M:H]),
   html(M:H,Tokens,[]),
   with_output_to(string(S),print_html(Tokens)),
   debug(pengutils,'write_html output: ~s',[S]),
   pengine_output(S).

term_rendering(html(Stuff),_,Opts) --> 
   {option(module(M),Opts)},
   {debug(pengutils,'Rendering as HTML: ~q',[Stuff])},
   html(M:Stuff).

