/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(musiclab,
   [  kern_pc_hist/2
   ,  pitch_class/2
   ,  pitch_class_number/2
   ,  pc_number_name/2
   ]).

:- use_module(library(persistency)).

:- use_module(library(humdrum)).
:- use_module(library(humdrum/kern)).
:- use_module(library(humdrum/kernutils)).
:- use_module(library(humdrum/dynam)).
:- use_module(library(humdrum/humdrum_world)).
:- use_module(library(typedef)).
:- use_module(library(memo)).

:- type pitch_class ---> a ; b ; c ; d ; e ; f ; g ; sharp(pitch_class) ; flat(pitch_class).

:- volatile_memo kern_pc_hist(+path:ground, -hist:list(pair(pitch_class,nonneg))).

% ------------ reading kern ----------------

pitch_class_number(sharp(PC),N) :- !, pitch_class_number(PC,M), N is (M+1) mod 12.
pitch_class_number(flat(PC),N) :- !, pitch_class_number(PC,M), N is (M-1) mod 12.
pitch_class_number(c,0). 
pitch_class_number(d,2). 
pitch_class_number(e,4). 
pitch_class_number(f,5). 
pitch_class_number(g,7). 
pitch_class_number(a,9). 
pitch_class_number(b,11).

kern_pc_hist(Path,Hist) :-
   with_kern_module(Path,utf8,M,findall(PC-N,aggregate(count,mod_note_pc(M,PC),N),Hist)).

% pc_hist_to_num(Hist1,Hist2) :-
%    findall(PCN-X, (member(PC-X,Hist1), pitch_class_number(PC,PCN)), Hist2),
%    numlist(0,11,PCNs),
%    maplist(pc_number_name,PCNs,PCNames),
%    maplist(\PCN^Count^(member(PCN-Count,Hist2) -> true; Count=0),PCNs,Counts),
   

mod_note_pc(M,PC) :- 
   M:note(pitch(P),_,_,_), 
   pitch_class(P,PC).

pc_number_name(0,"c").
pc_number_name(1,"c#").
pc_number_name(2,"d").
pc_number_name(3,"d#").
pc_number_name(4,"e").
pc_number_name(5,"f").
pc_number_name(6,"f#").
pc_number_name(7,"g").
pc_number_name(8,"g#").
pc_number_name(9,"a").
pc_number_name(10,"a#").
pc_number_name(11,"b").



