:- module(mlfigs, [ml_fig/6, ml_fig/5,ml_post/3, ml_opts/3]).

%:- use_module(library(dcg_core)).
:- use_module(library(dcg_pair)).
:- use_module(library(computations),[unzip/3, (*)/4]).
:- use_module(library(mlserver)).
:- use_module(library(optutils)).

% ------- tools for building matlab charts -------
ml_fig(Type,XL,YL,Datasets,F) :- ml_fig(Type,XL,YL,Datasets,[],F).
ml_fig(Type,XL,YL,Datasets,Opts,fig(Code;xlabel(q(XL));ylabel(q(YL)),Opts1)) :-
   unzip(Datasets,Names,Data),
   maplist(term_to_atom*atom_string,Names,Labels),
   compile(Type,Labels,Data,Opts,Opts1,Cmds,[]), 
   sequence(Cmds,Code).

ml_post(Code,fig(Code0),fig(Code0;Code)).
ml_post(Code,fig(Code0,O),fig(Code0;Code,O)).
ml_opts(Opts,fig(Code),fig(Code,Opts)).
ml_opts(Opts,fig(Code,Opts0), fig(Code,Opts1)) :-
   merge_options(Opts,Opts0,Opts1).


compile(T,Names,Data,Opts,Opts1) -->
   plot(T,Data),
   {option_default_select(legend(Pos),best,Opts,Opts1)},
   [box("off"), set(gca,"TickDir","out")],
   ( {Pos=off} -> []
   ; [legend(cell(Names),"Location",q(Pos),
                        "LineWidth",0.25*get(gcf,"DefaultAxesLineWidth"))]
   ).

sequence([C],C) :- !.
sequence([C1|Cs],C1;Ss) :- sequence(Cs,Ss).

pairs_to_cell(Pairs,{X,Y}) :- unzip(Pairs,X,Y).

plot(bars,Data) --> plot(bars(grouped),Data).
plot(bars(Arr),Data) --> plot(multi((x,y,varargin)\\bar(x,y,q(Arr),"EdgeColor","none",cref(varargin,[':']))),Data).
plot(areas,Data) --> plot(multi(@area),Data).
plot(multi(Fn),Data) --> 
   {length(Data,L)},
   {maplist(pairs_to_cell,Data,Cells)},
   [multibar(Fn,cell(Cells)),caxis([1,L+1])].
plot(scat(T,Ms),Points) -->
   hold(run_left(foldl(scat(T,Ms),Points),0,N)),
   [caxis([1,N+1])].
plot(lines,Points) -->
   {length(Points,N)},
   hold(run_left(foldl(line(N),Points),0,_)).

scat(o,Ms,Points) -->
   \< (succ, dcg_core:get(N)), 
   {unzip(Points,X,Y), length(Points,L), nth1(N,Ms,M)},
   \> [scatter(X,Y,get(gcf,"DefaultLineMarkerSize").^2,repmat(N,L,1),M)].
scat(f,Ms,Points) -->
   \< (succ, dcg_core:get(N)), 
   {unzip(Points,X,Y), length(Points,L), nth1(N,Ms,M)},
   \> [scatter(X,Y,get(gcf,"DefaultLineMarkerSize").^2,repmat(N,L,1),M,"filled")].

scat(p,Ms,Points) -->
   \< (succ, dcg_core:get(N)), {marker(N,M)},
   {unzip(Points,X,Y)},
   {nth1(N,Ms,M)},
   \> [scat(arr([X,Y]),"marker",M)].	

line(N,Xs-Ys) -->
   \< (succ, dcg_core:get(I)),
   \> [plot(Xs,Ys,"-","Color",row(get(gcf,"Colormap"),floor(I/N)))].	

marker(N,M) :-
    I is N mod 5,
    nth0(I,["r.","g.","c.","b.","m."],M).

hold(G) --> [newplot,hold("on")], phrase(G), [hold("off")].
