/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(insist, [insist/1,insist/2, insist/3]).
:- meta_predicate insist(0,:), insist(0), insist(+,0,:).

insist(G) :- insist(G,failed(G)).
insist(G,Ex) :- call(G) -> true; throw(Ex).
insist(det,G,Ex) :- insist(G,Ex).
insist(multi,G,Ex) :- call(G) *-> true; throw(Ex).

user:goal_expansion(insist(G),X) :- user:goal_expansion(insist(G,failed(G)),X).
user:goal_expansion(insist(G,Ex),(G->true;throw(Ex))).
user:goal_expansion(insist(det,G,Ex),X) :- user:goal_expansion(insist(G,Ex),X).
user:goal_expansion(insist(multi,G,Ex),(G*->true;throw(Ex))).
