/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dsp, 
      [  spectrogram/2
      ,  spectrogram/3
      ,  spectrum/2
      ,  sum/2
      ]).

:- use_module(library(semweb/rdf_db)).
:- use_module(library(sandbox)).
:- use_module(library(rdfutils)).
:- use_module(library(memo)).
:- use_module(library(mlserver)).

:- set_prolog_flag(double_quotes,string).

:- setting(specgram_dynamic_range,number,90,"Dynamic range in dB for spectrograms").

spectrogram(URI,X) :-
   rdf_text(URI,beets:path,P), 
   X===specgrm( monofile(P), hanning(2048),512).

:- volatile_memo spectrum(+atom,-ground).
spectrum(URI,X) :-
   spectrogram(URI,Y),
   X1===sum(Y,2),
   persist_item(X1,X).

spectrogram(URI,Offset,Length) :-
   setting(specgram_dynamic_range,DBs),
   (  cp_audio:audio_file(URI,P,Fmt),
      (  Fmt=just(aac) 
      -> MSignal=sndfile(q(P),q(enc),q(aac))
      ;  MSignal=sndfile(q(P))
      )
   ;  cp_audio:audio_link(URI,P,just(mp3)),
      MSignal=mp3file(q(P))
   ), !,
   ?? (specgrm( taket(Length,dropt(Offset,mixdown(MSignal))), 
                hanning(2048),512,"range",DBs,"offset",Offset); 
       ylim([0,15])).

sum(Items,Sum) :-
   once(member(X,Items)),
   D===numdims(X)+1,
   Sum===sum(cellcat(D,cell(Items)),D).

sandbox:safe_primitive(dsp:spectrogram(_,_,_)).
