/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dml_swish, []).

:- use_module(library(sandbox)).
:- use_module(library(humdrum)).

:- use_module(swish:library(http/html_write)).
:- use_module(swish:library(pengines)).
:- use_module(swish:library(memo)).
:- use_module(swish:library(rdfutils)).
:- use_module(swish:library(dataset)).
:- use_module(swish:library(dlogic)).
:- use_module(swish:library(pengutils)).

user:file_search_path(example,dml(examples)).

sandbox:safe_meta(settings:setting(_,_),[]).
sandbox:safe_primitive(error:has_type(_,_)).
sandbox:safe_primitive(rdf_label:literal_text(_,_)).
sandbox:safe_primitive(humdrum:hum_read(_,_,_)). % could check path here..
sandbox:safe_primitive(musicbrainz:mb_query(_,_,_,_)).
sandbox:safe_primitive(humdrum_p2r:hum_uri_path(_,_)).

sandbox:safe_meta('$dicts':eval_dict_function(Func,_,Dict,Out),Goals) :- !,
   (  safe_func(Func), Goals=[]
   ;  is_dict(Dict,Tag), nonvar(Tag), Goals=[call(Tag:Func,Dict,Out)]
   ).
safe_func(get(_)).
safe_func(put(_)).
safe_func(put(_,_)). 
