/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module( dlogic, [ ext/2, lambda/3, unary/2 ]).

:- use_module(library(semweb/rdf_db)).
:- use_module(library(semweb/rdfs)).
:- use_module(library(sandbox)).
:- use_module(library(rdfutils)).

% :- meta_predicate unary(:,-).
:- meta_predicate lambda(-,0,-).
:- rdf_meta ext(t,o).

:- op(400,xfx,~).

ext((C1,C2),X) :- !, ext(C1,X), ext(C2,X).
ext(C1;C2, X) :- !, ext(C1,X); ext(C2,X).
ext(inv(P) is Q, X) :- !, rdf_has(V,P,X), call(Q,V).
ext(P is Q, X) :- !, rdf_has(X,P,V), call(Q,V).
ext(q(P,Q), X) :- !, rdf(X,P,literal(Q,_)).
ext(NS:Class,X) :- !, rdf_global_id(NS:Class,C), rdfs_individual_of(X,C).
ext(Class,X) :- atomic(Class), rdfs_individual_of(X,Class).

lambda(X,Goal,Y) :-
   copy_term(X-Goal,Y-Goal1),
   call(Goal1).


unary((Binary -> Unary), X) :- !, binary(Binary,X,Y), unary(Unary,Y).
unary(\Pred,X) :- !, call(Pred,X).
unary((U1,U2),X) :- !, unary(U1,X), unary(U2,X).
unary((U1;U2),X) :- !, unary(U1,X); unary(U2,X).
unary(a(Class),X) :- !, rdf_global_id(Class,C), rdfs_individual_of(X,C).
unary(P~Q,X) :- !, rdf(X,P,literal(Q,_)).

binary(p(P),X,Y) :- !, rdf_global_id(P,P1), rdf(X,P1,Y).
binary(ip(P),X,Y) :- !, rdf_global_id(P,P1), rdf(Y,P1,X).
binary(P~Q,X,Y) :- !, rdf_global_id(P,P1), rdf(X,P1,literal(Q,Y)).
binary(\Pred,X,Y) :- !, call(Pred,X,Y).
binary(text,X,Y) :- !, literal_text(X,Y).
binary(num,X,Y) :- !, literal_number(X,Y).


sandbox:safe_meta(dlogic:lambda(_,Goal,_),[Goal]).

