/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dictutils, 
      [  print_dict/1
      ,  print_dict/2
      ,  print_dict/3
      ,  tag/2
      ]).

:- use_module(library(lambda)).

print_dict(Dict) :- print_dict(Dict,[]).
print_dict(Dict,Opts) :- print_dict(current_output,Dict,Opts).
print_dict(Str,Dict,Opts) :-
   option(exclude(Exc),Opts,\_^fail),
   option(include(Inc),Opts,\_^true),
   findall(F:V, (get_dict(F,Dict,V),call(Inc,F:V), \+call(Exc,F:V)), Pairs),
   aggregate_all(max(FL),(member(F:_,Pairs),atom_length(F,FL)),Max),
   forall( member(F:V,Pairs), format(Str,"~t~2+~t~w~*+: ~p\n",[F,Max,V])).

tag(Tag,Dict) :- is_dict(Dict,Tag).
