/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(csvutils, [uri_to_csv/2]).

:- use_module(library(insist)).
:- use_module(api(archive)).

:- set_prolog_flag(double_quotes,string).

%% uri_to_csv(+URI:uri, -Rows:list(row)) is det.
%
%  Read contents of CSV and return a list of terms with functor row/N, where
%  N is the number of columns in the CSV.
uri_to_csv(URI,Rows) :- with_input_from_uri(URI,load_csv_from_stream(Rows)).

load_csv_from_stream(Rows,Stream) :- 
	read_stream_to_codes(Stream,Codes),
	insist(phrase(csv(Rows,[match_arity(false),convert(true)]),Codes),
          csv_parse_failed).
