:- module(code_cache, 
      [  clean_code_cache/1
      ,  cache_code/3
      ,  cache_code/2
      ,  call_cached/2
      ]).

:- use_module(library(insist)).

:- meta_predicate cache_code(0,-).
:- meta_predicate cache_code(+,0,-).


cache_code(Code,Code1) :- cache_code(false,Code,Code1).
cache_code(MultiUse,Code,code_cache:call_cached(ID,MultiUse)) :-
   uuid(ID),
   get_time(T),
   recorda(ID,code_cache(T,Code)).

call_cached(ID,Keep) :-
   insist(recorded(ID,code_cache(_,Code),Ref),code_not_in_cache(ID)),
   (Keep=false -> erase(Ref); true),
   call(Code).

clean_code_cache(MaxAge) :-
   get_time(Now),
   Oldest is Now-MaxAge,
   forall( ( recorded(_,code_cache(T,Code),Ref), T<Oldest), 
           ( debug(code_cache,'Removing old cached code: ~q',[Code]),
             erase(Ref))).

:- multifile sandbox:safe_meta/2.
sandbox:safe_meta(code_cache:call_cached(ID,_),[Code]) :-
   insist(recorded(ID,code_cache(_,Code)),code_not_in_cache(ID)).

