/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(backend_json, 
      [  python_json/3
      ,  python_apply/3
      ,  python_call/3
      ,  python_call/4
      ,  python_call/5
      ]).

:- use_module(library(http/json)).

python_apply(Module:Function,Args,Result) :- !,
   Input = _{ module:Module, function:Function, arguments:Args },
   python_json('json_wrapper.py', Input, Output),
   (  Output=error{value:Msg} -> throw(python_json_error(Msg,Module:Function))
   ;  Output=ok{value:Result}
   ).
python_apply(Function,Args,Result) :- atom(Function),
   python_apply('__builtin__':Function,Args,Result).

python_call(ModFunc,A1,Result) :- python_apply(ModFunc,[A1],Result).
python_call(ModFunc,A1,A2,Result) :- python_apply(ModFunc,[A1,A2],Result).
python_call(ModFunc,A1,A2,A3,Result) :- python_apply(ModFunc,[A1,A2,A3],Result).

python_json(Script,Input,Output) :-
   setup_call_cleanup(
      process_create( dml(python/Script),[],
                      [ cwd(dml(python)), process(PID),
                        stdin(pipe(ToScript)), stdout(pipe(FromScript))]),
      call_cleanup(
         (  call_cleanup(json_write_dict(ToScript,Input,[width(0),tag(tag)]), close(ToScript)),
            json_read_dict(FromScript,Output,[tag(tag)])
         ), exception(_), process_kill(PID)),
      (close(FromScript), process_wait(PID,_))
   ).

