/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dml_permissions, [file_permission/2]).

/** <module> control public access to DML resources
 */

%% file_permission(+File,-Permission:oneof([public,user,private])) is det.
%  This predicate is called to check whether or not the contents of a given
%	file should be available. There are three levels of access:
%		*  public
%		   Accessible to everyone.
%		*  user
%		   Accessible to registered, logged in Cliopatria users.
%	   *  private
%	      Accessible to no-one.
%  The default level is private for all files. If you wish to make some files
%  available, you must copy (not link) this file to the 'config-available' directory
%  of your Cliopatria installation and edit the definition of file_permission/2
%  as you see fit.

%file_permission(Path,public) :- atom_concat('/home/dml/lib/mazurka/',_,Path), !.
file_permission(_,public) :- user_db:logged_on(admin).
file_permission(_,private).

