/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(cp_table,
      [ table_from_goal//2
      ]).

:- meta_predicate table_from_goal(1,+,?,?).

:- use_module(library(http/http_dispatch),[http_link_to_id/3]).
:- use_module(library(http/html_write)).
:- use_module(library(http/html_head)).
:- use_module(library(dcg_core)).

table_from_goal(Goal,Opts) -->
   {findall(Row,call(Goal,Row),Rows)},
   (  {option(headings(Heads),Opts)}
   -> html(table([\table_heads(Heads), \seqmap(table_row,Rows)]))
   ;  html(table(\seqmap(table_row,Rows)))
   ).

table_heads(Row) -->
   html(tr(\seqmap(table_head,Row))).
table_row(Row) -->
   html(tr(\seqmap(table_cell,Row))).

table_cell(Cell) --> html(td(Cell)).
table_head(Cell) --> html(th(Cell)).


