/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
:- module(smartimg, [image//4]).

:- use_module(library(http/html_write)).
:- use_module(library(http/html_head)).
:- use_module(library(http/js_write)).

image(false,URL,W,H) --> html(img([src=URL, class=matlabfig, style=("width:~dcm;height:~dcm"-[W,H])],[])).
image(true,URL,W,H) --> 
   html_requires(js('smartimg.js')),
   {gensym(img,ID)},
   html(img([alt="loading image data", id=ID, class=matlabfig, 
             style=("width:~dcm;height:~dcm"-[W,H])],[])),
   js_script({|javascript(ID,URL)||load_img2(ID,URL)|}).

