/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University of London
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dml_overview, []).

/** <module> DML Overview pages
*/

:- use_module(library(http/html_write)).
:- use_module(library(http/html_head)).
:- use_module(library(http/http_dispatch)).
:- use_module(library(semweb/rdf_db)).
:- use_module(library(dcg_core)).
:- use_module(library(rdfutils)).
:- use_module(library(httpfiles),[reply_html_page/4]).
% :- use_module(components(score)).
% :- use_module(api(score)).

:- set_prolog_flag(double_quotes,string).

:- http_handler(root(dml/overview/top), dml_overview, []).

dml_overview(_Request) :-
   rdf(Rec,beets:title,literal(substring('I want to talk about you'),_)),
   reply_html_page(cliopatria(demo), [title("DML Overview")],
                   [ html_post(head,style( ["h2 { margin-top:1em }"]))
                   , h1("Digital Music Lab Overview") 
                   , h2("Knowledge representation: relational models and RDF")
                   , h2("Exploring the collections")
                   , p([ "The music libraries are organised in to 'graphs' (RDF sub-databases) on the basis of their origin. "
                       , "One way to explore them is to start from the page for each graph, and examine the predicates and classes "
                       , "the use to describe their content. For example, one can browse a list of values of the 'charm:composer' "
                       , "predicate and from their find recordings that have particular values of that property."])
                   , p(\ll(list_predicates,[graph(bl_p2r)],"Predicates in the British Library recordings graph"))
                   , \ll(list_predicates,[graph(charm_p2r)],"Predicates CHARM collection graph")
                   % , p("The CHARM collection contains works by many composers. This pie chart shows the top 25 composer by number of recordings.")
                   % , \charm_composers_plot
                   , h2("The semantic web")
                   , p([ "DML can follow Musicbrainz URIs to retrieve information from the Linkedbrainz SPARQL endpoint and "
                       , "the Musicbrainz XML web service. Information from Linkedbrainz is already in Music Ontology format, "
                       , "but information from Musicbrainz is reorganised on import to conform to the Music Ontology's schema "
                       , "of events to describe composition, recordinging, and other music related data." ])
                   , p(\ll(list_resource,[r(Rec)],"A recording with Musicbrainz links."))
                   , h2("Symbolic scores")
                   , p("The database includes symbolic scores in Humdrum/Kern format obtained from the KernScores website.")
                   , p(\ll(list_predicate_resources,[side=object,graph=humdrum_p2r,predicate='http://dml.org/humdrum/schema/refcode/COM'],"Humdrum scores by Bach"))
                   , h2("Computation and memoisation")
                   , \ll(list_instances,[graph=memo_p2r,class='http://dml.org/memo/Function'],"Memoised functions")
                   , h2("SWISH: collaborative web-based Prolog")
                   , p([ "DML embeds a SWISH server to provide a web-based Prolog programming environment with access to the "
                       , "DML database and analsis functions, as well as facilities for visualising results and collaborative development." ])
                   , p(html(a(href('/cp/swish/p/c3examples.swinb#'),"Music library statistics visualised using C3 graphics")))
                   ],
                   [stable]).

ll(ID,Params,HTML) --> line(\link(ID,Params,HTML)).
link(ID,Params,HTML) -->                
   {http_link_to_id(ID,Params,Link)},
   html(a(href(Link),HTML)).

line(HTML) --> html(HTML), html(br([])).

:- rdf_meta collection_property_hist(+,r,+,-).
collection_property_hist(Coll,P,Min,c3{data:_{columns:Pairs, type:pie}}) :-
   setof([C,N], (collection_property_value_count(Coll,P,literal(C),N),N>Min), Pairs).

collection_property_value_count(Collection,Property,Value,Count) :-
	aggregate(count, R^(collection(Collection,R), rdf_has(R,Property,Value)), Count).

collection(charm,X) :- rdf(X,charm:file_name,_).
collection(bl,X) :- rdf(X,rdf:type,mo:'Signal',bl_p2r).

charm_composers_plot -->
   {swish_render:renderer(c3,C3Mod,_)},
   {collection_property_hist(charm,dml:composer,25,Pairs)},
   % !!! This is not working.
   C3Mod:term_rendering(Pairs,_,[]).

