/* Part of DML (Digital Music Laboratory)
	Copyright 2014-2015 Samer Abdallah, University College London.
	 
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

:- module(dbpedia, []).
:- use_module(library(semweb/rdf_db)).
:- use_module(library(semweb/rdf_library)).

/** <module> Provide DBPedia schema and namespaces

*/

:- rdf_register_ns(dbpedia, 'http://dbpedia.org/').
:- rdf_register_ns(dbprop, 'http://dbpedia.org/property/').
:- rdf_register_ns(dbont, 'http://dbpedia.org/ontology/').
:- rdf_attach_library(dbpedia(rdf)).
:- rdf_load_library(dbpedia).
