# module uripattern

by Samer Abdallah, UCL, 2014


This directory contains several alternative implementations of a small URI grammar
which supports both generation and parsing (pattern-matching) of URIs.

There are two variants of the language. The earlier design is quite flexible but
leads to heavily non-deterministic parsing, which is perhaps not what one wants
for URI computations which might potentially be called very frequently. The later
design reduces or eliminates this non-determinism, depending on the implementatation.

### Grammar

We describe the pattern grammar in terms of an algebraic datatype for the pattern language.


	uri_pattern ---> prefix:uri_part
	               ; uri_part.

	P :: prefix :- rdf_current_prefix(P). % any registered prefix atom
	M :: macro_invocation :- uripattern:def(M,_).

	uri_part ---> \macro_invocation
	            ; uri_part/uri_part   % slash separated concatenation
					; uri_part+uri_part   % direct concatenation
				   ; num(number)         % decimal repn of number
					; enc(atomic)         % HTML form-encoded atom
					; atm(atomic)         % any atomic value
					; <any ground atom>
					.

The more deterministic grammar removes direct concatenation and arbitrary atom parsing
but adds a tail/1 functor to capture all the remaining characters in the URI:

	uri_part ---> \macro_invocation
	            ; uri_part/uri_part   % slash separated concatenation
				   ; num(number)         % decimal repn of number
					; enc(atomic)         % HTML form-encoded atom
					; tail(atomic)        % matches rest of URI
					; <any ground atom>
					.

This grammar as written is not quite strict enough to enforce the rule that any tail/1
term must be the last thing in the pattern. The implementations are slightly less strict
than this this specification.


### Example

Given the following declarations:
	
	:- rdf_register_prefix(eg,'http://wwww.example.org/').
	uripattern:def(matrix(X,Y),num(X)/num(Y)).

Then URIs can be generated as follows:

	pattern_uri(eg:home,A).
			~> A='http://www.example.org/home'
	pattern_uri(eg:files/tail('home/chomsky/.profile'),A).
			~> A='http://www.example.org/files/home/chomsky/.profile'
	pattern_uri(eg:people/enc('Chomsky, N')/pets,A).   
			~> A='http://www.example.org/people/Chomsky%2c%20N/pets'
	pattern_uri(eg:chessboard/matrix(3,6),A).
			~> A='http://www.example.org/chessboard/3/6'

URIs can also be parsed, eg as follows

	pattern_uri(eg:files/tail(Path),       'http://www.example.org/files/home/chomsky/.profile').
			~> Path=
	pattern_uri(eg:people/enc(Name)/pets,  'http://www.example.org/people/Chomsky%2c%20N/pets').
			~> Name='Chomsky, N'
	pattern_uri(eg:chessboard/matrix(X,Y), 'http://www.example.org/chessboard/3/6').
			~> X=3, Y=6


### Implementations

There are several implementations:

uripattern\_constraint : Works by splicing atoms and uses delayed goals to handle arbitrary modes.

uripattern\_string : Works by splicing strings.

uripattern\_atom : Works by splicing atoms.

uripattern\_dcg :	Converts URI to and from a list of codes and uses a DCG.

uripattern\_detdcg : A more deterministic DCG

uripattern\_detstring : A more deterministic version of string splicing.


