# Part of DML (Digital Music Laboratory)
# Copyright 2014-2015 Samer Abdallah, University College London
 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import sys,traceback

def for_each(items,f):
    bad=[]
    num_ok=0

    for x in items:
        try: f(x); num_ok+=1
        except Exception as ex:
            bad.append({'item':x, 'error':str(ex)})
            
            # printing exception info
            #traceback.print_exc()
            
    return {'ok_count':num_ok, 'failures':bad}

def discrete_hist(domain,counts): return {'domain':domain, 'counts':counts}
def continuous_hist(edges,counts): return {'edges':edges,'counts':counts}
def decode_tagged(parser_table, v): return parser_table[v['tag']](v['value'])
def print_status(msg): sys.stderr.write(msg+'\n')
