/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.frequentpatterns.zart.AlgoZart;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TFTableFrequent;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestZart_saveToMemory {
    public static void main(String[] args) throws IOException {
        TransactionDatabase context = new TransactionDatabase();
        context.loadFile(MainTestZart_saveToMemory.fileToPath("contextZart.txt"));
        double minsup = 0.4;
        AlgoZart zart = new AlgoZart();
        TZTableClosed results = zart.runAlgorithm(context, minsup);
        TFTableFrequent frequents = zart.getTableFrequent();
        zart.printStatistics();
        int countClosed = 0;
        int countGenerators = 0;
        System.out.println("======= List of closed itemsets and their generators ============");
        int i = 0;
        while (i < results.levels.size()) {
            System.out.println("LEVEL (SIZE) : " + i);
            for (Itemset closed : results.levels.get(i)) {
                System.out.println(" CLOSED : " + closed.toString() + "  supp : " + closed.getAbsoluteSupport());
                ++countClosed;
                System.out.println("   GENERATORS : ");
                for (Itemset generator : results.mapGenerators.get(closed)) {
                    ++countGenerators;
                    System.out.println("     =" + generator.toString());
                }
            }
            ++i;
        }
        System.out.println(" NUMBER OF CLOSED : " + countClosed + " NUMBER OF GENERATORS : " + countGenerators);
        System.out.println("======= List of all frequent itemsets ============");
        int countFrequent = 0;
        int i2 = 0;
        while (i2 < frequents.levels.size()) {
            System.out.println("LEVEL (SIZE) : " + i2);
            for (Itemset itemset : frequents.levels.get(i2)) {
                ++countFrequent;
                System.out.println(" ITEMSET : " + itemset.toString() + "  supp : " + itemset.getAbsoluteSupport());
            }
            ++i2;
        }
        System.out.println("NB OF FREQUENT ITEMSETS : " + countFrequent);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestZart_saveToMemory.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

