/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class Bitmap {
    public static long INTERSECTION_COUNT = 0L;
    private BitSet bitmap = new BitSet();
    int lastSID = -1;
    int firstItemsetID = -1;
    private int support = 0;

    Bitmap(int lastBitIndex) {
        this.bitmap = new BitSet(lastBitIndex + 1);
    }

    private Bitmap(BitSet bitmap) {
        this.bitmap = bitmap;
    }

    public void registerBit(int sid, int tid, List<Integer> sequencesSize) {
        int pos = sequencesSize.get(sid) + tid;
        this.bitmap.set(pos, true);
        if (sid != this.lastSID) {
            ++this.support;
        }
        if (this.firstItemsetID == -1 || tid < this.firstItemsetID) {
            this.firstItemsetID = tid;
        }
        this.lastSID = sid;
    }

    private int bitToSID(int bit, List<Integer> sequencesSize) {
        int result = Collections.binarySearch(sequencesSize, bit);
        if (result >= 0) {
            return result;
        }
        return 0 - result - 2;
    }

    public int getSupport() {
        return this.support;
    }

    Bitmap createNewBitmapSStep(Bitmap bitmapItem, List<Integer> sequencesSize, int lastBitIndex) {
        BitSet newBitset = new BitSet(lastBitIndex);
        Bitmap newBitmap = new Bitmap(newBitset);
        int bitK = this.bitmap.nextSetBit(0);
        while (bitK >= 0) {
            int sid = this.bitToSID(bitK, sequencesSize);
            int lastBitOfSID = this.lastBitOfSID(sid, sequencesSize, lastBitIndex);
            boolean match = false;
            int bit = bitmapItem.bitmap.nextSetBit(bitK + 1);
            while (bit >= 0 && bit <= lastBitOfSID) {
                newBitmap.bitmap.set(bit);
                match = true;
                int tid = bit - sequencesSize.get(sid);
                if (this.firstItemsetID == -1 || tid < this.firstItemsetID) {
                    this.firstItemsetID = tid;
                }
                bit = bitmapItem.bitmap.nextSetBit(bit + 1);
            }
            if (match) {
                if (sid != newBitmap.lastSID) {
                    ++newBitmap.support;
                }
                newBitmap.lastSID = sid;
            }
            bitK = lastBitOfSID;
            bitK = this.bitmap.nextSetBit(bitK + 1);
        }
        return newBitmap;
    }

    private int lastBitOfSID(int sid, List<Integer> sequencesSize, int lastBitIndex) {
        if (sid + 1 >= sequencesSize.size()) {
            return lastBitIndex;
        }
        return sequencesSize.get(sid + 1) - 1;
    }

    Bitmap createNewBitmapIStep(Bitmap bitmapItem, List<Integer> sequencesSize, int lastBitIndex) {
        BitSet newBitset = new BitSet(lastBitIndex);
        Bitmap newBitmap = new Bitmap(newBitset);
        int bit = this.bitmap.nextSetBit(0);
        while (bit >= 0) {
            if (bitmapItem.bitmap.get(bit)) {
                newBitmap.bitmap.set(bit);
                int sid = this.bitToSID(bit, sequencesSize);
                if (sid != newBitmap.lastSID) {
                    ++newBitmap.support;
                }
                newBitmap.lastSID = sid;
                int tid = bit - sequencesSize.get(sid);
                if (this.firstItemsetID == -1 || tid < this.firstItemsetID) {
                    this.firstItemsetID = tid;
                }
            }
            bit = this.bitmap.nextSetBit(bit + 1);
        }
        newBitset.and(bitmapItem.bitmap);
        return newBitmap;
    }
}

