/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.FrequentPatternEnumeration;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.FrequentPatternEnumerationFacade;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.candidatePatternsGeneration.CandidateGenerator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AlgoSPADE {
    public long joinCount;
    protected double minSup;
    protected double minSupRelative;
    protected boolean dfs;
    Saver saver = null;
    public long start;
    public long end;
    protected List<EquivalenceClass> frequentItems;
    private AbstractionCreator abstractionCreator;
    private int numberOfFrequentPatterns;

    public AlgoSPADE(double support, boolean dfs, AbstractionCreator abstractionCreator) {
        this.minSup = support;
        this.abstractionCreator = abstractionCreator;
        this.dfs = dfs;
    }

    public void runAlgorithm(SequenceDatabase database, CandidateGenerator candidateGenerator, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        this.minSupRelative = (int)Math.ceil((double)database.size() * this.minSup);
        if (this.minSupRelative == 0.0) {
            this.minSupRelative = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.runSPADE(database, candidateGenerator, (long)this.minSupRelative, this.dfs, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    public void runAlgorithmParallelized(SequenceDatabase database, CandidateGenerator candidateGenerator, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        this.minSupRelative = (int)Math.ceil(this.minSup * (double)database.size());
        if (this.minSupRelative == 0.0) {
            this.minSupRelative = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.runSPADEFromSize2PatternsParallelized2(database, candidateGenerator, (long)this.minSupRelative, this.dfs, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void runSPADE(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1sequences = this.getPatterns(this.frequentItems);
        if (keepPatterns) {
            for (Pattern atom : size1sequences) {
                this.saver.savePattern(atom);
            }
        }
        database = null;
        EquivalenceClass rootClass = new EquivalenceClass(null);
        for (EquivalenceClass atom : this.frequentItems) {
            rootClass.addClassMember(atom);
        }
        FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupRelative, this.saver);
        frequentPatternEnumeration.setFrequentPatterns(this.frequentItems.size());
        frequentPatternEnumeration.execute(rootClass, dfs, keepPatterns, verbose, null, null);
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
        this.joinCount = FrequentPatternEnumeration.INTERSECTION_COUNTER;
    }

    protected void runSPADEFromSize2Sequences(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1Patterns = this.getPatterns(this.frequentItems);
        this.saver.savePatterns(size1Patterns);
        List<EquivalenceClass> size2Patterns = database.getSize2FrecuentSequences(this.minSupRelative);
        Collection<Pattern> size2sequences = this.getPatterns(size2Patterns);
        this.saver.savePatterns(size2sequences);
        size2Patterns.clear();
        database.clear();
        size2Patterns = null;
        database = null;
        FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupRelative, this.saver);
        frequentPatternEnumeration.setFrequentPatterns(size1Patterns.size() + size2sequences.size());
        size1Patterns = null;
        size2sequences = null;
        while (this.frequentItems.size() > 0) {
            EquivalenceClass frequentAtomClass = this.frequentItems.get(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("Exploring... " + frequentAtomClass);
            }
            frequentPatternEnumeration.execute(frequentAtomClass, dfs, keepPatterns, verbose, null, null);
            this.frequentItems.remove(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("\tWe found " + frequentPatternEnumeration.getFrequentPatterns() + " frequent patterns so far.");
            }
            MemoryLogger.getInstance().checkMemory();
        }
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
    }

    private Collection<Pattern> getPatterns(List<EquivalenceClass> equivalenceClasses) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (EquivalenceClass equivalenceClass : equivalenceClasses) {
            Pattern frequentPattern = equivalenceClass.getClassIdentifier();
            patterns.add(frequentPattern);
        }
        return patterns;
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.getRunningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Join count : ");
        sb.append(this.joinCount);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        sb.append(this.saver.print());
        sb.append("\n===================================================\n");
        return sb.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.end - this.start;
    }

    public double getMinSupRelative() {
        return this.minSupRelative;
    }

    public void clear() {
        this.frequentItems.clear();
        this.abstractionCreator = null;
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
    }

    protected void runSPADEFromSize2PatternsParallelized(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        Future future;
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1Patterns = this.getPatterns(this.frequentItems);
        this.saver.savePatterns(size1Patterns);
        List<EquivalenceClass> size2EquivalenceClass = database.getSize2FrecuentSequences(this.minSupRelative);
        Collection<Pattern> size2Sequences = this.getPatterns(size2EquivalenceClass);
        this.saver.savePatterns(size2Sequences);
        size2EquivalenceClass = null;
        database = null;
        FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupRelative, this.saver);
        frequentPatternEnumeration.setFrequentPatterns(size1Patterns.size() + size2Sequences.size());
        size1Patterns = null;
        size2Sequences = null;
        Runtime runtime = Runtime.getRuntime();
        int numberOfAvailableProcessors = runtime.availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numberOfAvailableProcessors);
        ArrayList<Future> set = new ArrayList<Future>();
        while (this.frequentItems.size() > 0) {
            EquivalenceClass frequentItem = this.frequentItems.get(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("Exploring " + frequentItem);
            }
            FrequentPatternEnumerationFacade callable = new FrequentPatternEnumerationFacade(frequentPatternEnumeration, frequentItem, dfs, keepPatterns, verbose, this.saver);
            future = pool.submit(callable);
            set.add(future);
            this.frequentItems.remove(this.frequentItems.size() - 1);
            MemoryLogger.getInstance().checkMemory();
        }
        try {
            int cont = 1;
            System.err.println("There are " + set.size() + " equivalence classes and " + numberOfAvailableProcessors + " available processors");
            while (!set.isEmpty()) {
                int i = 0;
                while (i < set.size()) {
                    future = (Future)set.get(i);
                    if (future.isDone()) {
                        System.err.println(String.valueOf(cont++) + ":this thread is done.");
                        set.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
            this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
            MemoryLogger.getInstance().checkMemory();
            pool.shutdown();
            pool.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            System.err.println("Problems with the concurrency!!");
            e.printStackTrace();
        }
    }

    protected void runSPADEFromSize2PatternsParallelized2(SequenceDatabase database, CandidateGenerator candidateGenerator, long minSupportCount, boolean dfs, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1Sequences = this.getPatterns(this.frequentItems);
        this.saver.savePatterns(size1Sequences);
        List<EquivalenceClass> size2EquivalenceClasses = database.getSize2FrecuentSequences(this.minSupRelative);
        Collection<Pattern> size2Sequences = this.getPatterns(size2EquivalenceClasses);
        this.saver.savePatterns(size2Sequences);
        this.numberOfFrequentPatterns = size1Sequences.size() + size2Sequences.size();
        size2EquivalenceClasses = null;
        database = null;
        Runtime runtime = Runtime.getRuntime();
        ExecutorService pool = Executors.newFixedThreadPool(runtime.availableProcessors());
        LinkedHashSet<Future<Void>> set = new LinkedHashSet<Future<Void>>();
        ArrayList<FrequentPatternEnumeration> enumerates = new ArrayList<FrequentPatternEnumeration>();
        while (this.frequentItems.size() > 0) {
            EquivalenceClass frequentAtom = this.frequentItems.get(this.frequentItems.size() - 1);
            if (verbose) {
                System.out.println("Exploring " + frequentAtom);
            }
            FrequentPatternEnumeration frequentPatternEnumeration = new FrequentPatternEnumeration(candidateGenerator, this.minSupRelative, this.saver);
            enumerates.add(frequentPatternEnumeration);
            FrequentPatternEnumerationFacade callable = new FrequentPatternEnumerationFacade(frequentPatternEnumeration, frequentAtom, dfs, keepPatterns, verbose, this.saver);
            Future<Void> future = pool.submit(callable);
            set.add(future);
            this.frequentItems.remove(this.frequentItems.size() - 1);
            MemoryLogger.getInstance().checkMemory();
        }
        try {
            pool.shutdown();
            pool.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            System.err.println("Problems with the concurrency!!");
        }
        FrequentPatternEnumeration fpe = new FrequentPatternEnumeration(candidateGenerator, this.minSup, this.saver);
        this.numberOfFrequentPatterns += fpe.getFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
    }
}

