/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp;

import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.Event;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.MyPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.SignTest;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class AlgoGoKrimp {
    ArrayList<Integer> characters;
    ArrayList<ArrayList<Event>> data;
    ArrayList<MyPattern> patterns;
    ArrayList<MyPattern> candidates;
    HashMap<Integer, String> labels;
    HashMap<Integer, ArrayList<Integer>> related_events;
    ArrayList<Integer> classlabels;
    int Nword;
    double comp_size;
    double uncomp_size;
    static final int NSTART = 1000;
    static final int NRELATED = 1000;
    BufferedWriter writer;

    public void gokrimp() throws IOException {
        long startTime = System.currentTimeMillis();
        this.initialization();
        ArrayList<MyPattern> ie = this.get_Initial_Patterns();
        MyPattern maxp = new MyPattern();
        while (true) {
            double max = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < ie.size()) {
                MyPattern mp;
                MyPattern prev = mp = ie.get(i);
                while ((mp = this.extend(mp)) != null) {
                    prev = mp;
                }
                if (prev.ben > max) {
                    maxp = prev;
                    max = prev.ben;
                }
                ++i;
            }
            if (max <= 0.0) break;
            this.addPattern(maxp);
            this.printMyPattern(maxp);
            this.remove(maxp);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        System.out.println("Compressed size: " + this.comp_size + ", uncompressed size: " + this.uncomp_size + ", compression ratio: " + this.uncomp_size / (0.0 + this.comp_size));
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("Running time: " + totalTime / 1000L + " seconds");
    }

    public void seqkrimp() throws IOException {
        MyPattern maxp = new MyPattern();
        block2: while (true) {
            double max = Double.NEGATIVE_INFINITY;
            int mi = this.getBestPattern();
            if (this.candidates.get((int)mi).ben > max) {
                maxp = new MyPattern(this.candidates.get(mi));
                max = this.candidates.get((int)mi).ben;
            }
            if (max <= 0.0) break;
            this.addPattern(maxp);
            this.printMyPattern(maxp);
            this.remove(maxp);
            this.candidates.remove(mi);
            int i = 0;
            while (true) {
                if (i >= this.candidates.size()) continue block2;
                this.candidates.get((int)i).ben = 0.0;
                this.candidates.get((int)i).freq = 0;
                this.candidates.get((int)i).g_cost = 0;
                ++i;
            }
            break;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Compressed size: " + this.comp_size + ", uncompressed size: " + this.uncomp_size + ", compression ratio: " + this.uncomp_size / (0.0 + this.comp_size));
    }

    void initialization() {
        this.patterns = new ArrayList();
        this.candidates = new ArrayList();
        this.related_events = new HashMap();
        this.Nword = 0;
        this.comp_size = 0.0;
        this.characters = new ArrayList();
        int i = 0;
        while (i < this.data.size()) {
            int j = 0;
            while (j < this.data.get(i).size()) {
                if (this.data.get((int)i).get((int)j).id >= this.characters.size()) {
                    int ii = this.characters.size();
                    while (ii < this.data.get((int)i).get((int)j).id + 1) {
                        this.characters.add(new Integer(0));
                        ++ii;
                    }
                }
                this.characters.set(this.data.get((int)i).get((int)j).id, this.characters.get(this.data.get((int)i).get((int)j).id) + 1);
                ++j;
            }
            this.Nword += this.data.get(i).size();
            ++i;
        }
        this.Nword += 2 * this.characters.size();
        i = 0;
        while (i < this.characters.size()) {
            MyPattern mp = new MyPattern();
            mp.ids.add(i);
            mp.ben = 0.0;
            mp.freq = this.characters.get(i) + 2;
            mp.g_cost = 0;
            this.patterns.add(mp);
            this.comp_size += (double)mp.freq * Math.log(this.Nword) / Math.log(2.0) - (double)mp.freq * Math.log(mp.freq) / Math.log(2.0);
            this.characters.set(i, this.patterns.size() - 1);
            ++i;
        }
        this.uncomp_size = this.comp_size;
        i = 0;
        while (i < this.data.size()) {
            Iterator<Event> it = this.data.get(i).iterator();
            while (it.hasNext()) {
                if (this.patterns.get((int)this.characters.get((int)it.next().id).intValue()).freq >= 25) continue;
                it.remove();
            }
            ++i;
        }
    }

    void addPattern(MyPattern pattern) {
        this.Nword = this.Nword - (pattern.freq - 1) * pattern.ids.size() + pattern.ids.size() + pattern.freq;
        this.comp_size -= pattern.ben;
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        int j = 0;
        while (j < pattern.ids.size()) {
            if (!hm.containsKey(pattern.ids.get(j))) {
                hm.put(pattern.ids.get(j), 1);
            } else {
                hm.put(pattern.ids.get(j), (Integer)hm.get(pattern.ids.get(j)) + 1);
            }
            ++j;
        }
        int i = 0;
        while (i < this.patterns.size()) {
            if (this.patterns.get((int)i).ids.size() == 1 && hm.containsKey(this.patterns.get((int)i).ids.get(0))) {
                this.patterns.get((int)i).freq -= (pattern.freq - 1) * (Integer)hm.get(this.patterns.get((int)i).ids.get(0));
                this.patterns.get((int)i).freq += ((Integer)hm.get(this.patterns.get((int)i).ids.get(0))).intValue();
            }
            ++i;
        }
        this.patterns.add(pattern);
    }

    MyPattern extend(MyPattern pattern) {
        ArrayList<Integer> ve = this.get_Extending_Events_SignTest(pattern.ids.get(pattern.ids.size() - 1));
        this.candidates.clear();
        int i = 0;
        while (i < ve.size()) {
            MyPattern can = new MyPattern();
            can.g_cost = 0;
            can.freq = 0;
            can.ben = 0.0;
            can.ids = new ArrayList<Integer>(pattern.ids);
            can.ids.add(ve.get(i));
            this.candidates.add(can);
            ++i;
        }
        if (this.candidates.isEmpty()) {
            return null;
        }
        int best = this.getBestPattern();
        if (this.candidates.get((int)best).ben > pattern.ben) {
            return this.candidates.get(best);
        }
        return null;
    }

    ArrayList<MyPattern> get_Initial_Patterns() {
        ArrayList<MyPattern> ie = new ArrayList<MyPattern>();
        int i = 0;
        while (i < this.patterns.size()) {
            if (this.patterns.get((int)i).freq >= 25) {
                ie.add(new MyPattern(this.patterns.get(i)));
            }
            ++i;
        }
        i = 0;
        while (i < ie.size()) {
            ((MyPattern)ie.get((int)i)).ben = ((MyPattern)ie.get((int)i)).freq;
            ++i;
        }
        Collections.sort(ie);
        while (ie.size() > 1000) {
            ie.remove(ie.size() - 1);
        }
        i = 0;
        while (i < ie.size()) {
            ie.get((int)i).ben = 0.0;
            ++i;
        }
        return ie;
    }

    ArrayList<Integer> get_Extending_Events_SignTest(Integer e) {
        if (this.related_events.containsKey(e)) {
            return this.related_events.get(e);
        }
        ArrayList<Integer> ve = this.getRelatedEvents(e);
        this.related_events.put(e, ve);
        return ve;
    }

    int getBestPattern() {
        int index = 0;
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.candidates.size()) {
            int j = 0;
            while (j < this.data.size()) {
                HashMap<Integer, ArrayList> hm = new HashMap<Integer, ArrayList>();
                ArrayList<ArrayList<Integer>> pos = new ArrayList<ArrayList<Integer>>();
                int k = 0;
                while (k < this.candidates.get((int)i).ids.size()) {
                    ArrayList a;
                    if (!hm.containsKey(this.candidates.get((int)i).ids.get(k))) {
                        a = new ArrayList();
                        a.add(k);
                        hm.put(this.candidates.get((int)i).ids.get(k), a);
                    } else {
                        a = (ArrayList)hm.get(this.candidates.get((int)i).ids.get(k));
                        a.add(k);
                        hm.put(this.candidates.get((int)i).ids.get(k), a);
                    }
                    pos.add(new ArrayList());
                    ++k;
                }
                k = 0;
                while (k < this.data.get(j).size()) {
                    if (hm.containsKey(this.data.get((int)j).get((int)k).id)) {
                        int l = 0;
                        while (l < ((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).size()) {
                            pos.get((Integer)((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).get(l)).add(this.data.get((int)j).get((int)k).ts);
                            ++l;
                        }
                    }
                    ++k;
                }
                ArrayList<ArrayList<Integer>> matches = this.getBestMatches(pos);
                this.candidates.get((int)i).freq += matches.size();
                this.candidates.get((int)i).g_cost += this.gap_cost(matches);
                ++j;
            }
            if (this.candidates.get((int)i).freq != 0) {
                ++this.candidates.get((int)i).freq;
                double com = this.get_Compress_Size_When_Adding(this.candidates.get(i));
                if (com < min) {
                    min = com;
                    index = i;
                }
            }
            ++i;
        }
        this.candidates.get((int)index).ben = this.comp_size - min;
        return index;
    }

    void remove(MyPattern pattern) {
        int j = 0;
        while (j < this.data.size()) {
            HashMap<Integer, ArrayList> hm = new HashMap<Integer, ArrayList>();
            ArrayList<ArrayList<Integer>> pos = new ArrayList<ArrayList<Integer>>();
            int k = 0;
            while (k < pattern.ids.size()) {
                ArrayList a;
                if (!hm.containsKey(pattern.ids.get(k))) {
                    a = new ArrayList();
                    a.add(k);
                    hm.put(pattern.ids.get(k), a);
                } else {
                    a = (ArrayList)hm.get(pattern.ids.get(k));
                    a.add(k);
                    hm.put(pattern.ids.get(k), a);
                }
                pos.add(new ArrayList());
                ++k;
            }
            k = 0;
            while (k < this.data.get(j).size()) {
                if (hm.containsKey(this.data.get((int)j).get((int)k).id)) {
                    int l = 0;
                    while (l < ((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).size()) {
                        pos.get((Integer)((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).get(l)).add(this.data.get((int)j).get((int)k).ts);
                        ++l;
                    }
                }
                ++k;
            }
            ArrayList<ArrayList<Integer>> matches = this.getBestMatches(pos);
            this.remove(matches, j);
            ++j;
        }
    }

    double get_Compress_Size_When_Adding(MyPattern pattern) {
        int new_Nword = this.Nword - (pattern.freq - 1) * pattern.ids.size() + pattern.ids.size() + pattern.freq;
        double com = this.comp_size;
        com += (double)new_Nword * Math.log(new_Nword) / Math.log(2.0) - (double)this.Nword * Math.log(this.Nword) / Math.log(2.0) - (double)pattern.freq * Math.log(pattern.freq) / Math.log(2.0);
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < pattern.ids.size()) {
            if (!hm.containsKey(pattern.ids.get(i))) {
                hm.put(pattern.ids.get(i), 1);
            } else {
                hm.put(pattern.ids.get(i), (Integer)hm.get(pattern.ids.get(i)) + 1);
            }
            ++i;
        }
        for (Integer key : hm.keySet()) {
            int new_freq = this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq - (Integer)hm.get(key) * pattern.freq + 2 * (Integer)hm.get(key);
            com -= (double)new_freq * Math.log(new_freq) / Math.log(2.0) - (double)this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq * Math.log(this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq) / Math.log(2.0);
        }
        return com += (double)pattern.g_cost;
    }

    ArrayList<ArrayList<Integer>> getBestMatches(ArrayList<ArrayList<Integer>> pos) {
        ArrayList<ArrayList<Integer>> matches = new ArrayList<ArrayList<Integer>>();
        block0: while (true) {
            ArrayList matrix = new ArrayList();
            int i = 0;
            while (i < pos.size()) {
                matrix.add(new ArrayList());
                ++i;
            }
            i = 0;
            while (i < pos.size()) {
                int j;
                if (i == 0) {
                    j = 0;
                    while (j < pos.get(0).size()) {
                        Event ww = new Event();
                        ww.ts = 0;
                        ww.id = pos.get(0).get(j);
                        ww.gap = 0;
                        ((ArrayList)matrix.get(0)).add(ww);
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < pos.get(i).size()) {
                        int index = 0;
                        int min = Integer.MAX_VALUE;
                        int mini = 0;
                        while (index < ((ArrayList)matrix.get(i - 1)).size() && ((Event)((ArrayList)matrix.get((int)(i - 1))).get((int)index)).id < pos.get(i).get(j)) {
                            if (((Event)((ArrayList)matrix.get((int)(i - 1))).get((int)index)).ts == Integer.MAX_VALUE) {
                                ++index;
                                continue;
                            }
                            int g = ((Event)((ArrayList)matrix.get((int)(i - 1))).get((int)index)).ts + this.bits(pos.get(i).get(j) - ((Event)((ArrayList)matrix.get((int)(i - 1))).get((int)index)).id);
                            if (g <= min) {
                                min = g;
                                mini = index;
                            }
                            ++index;
                        }
                        Event ww = new Event();
                        ww.ts = min;
                        ww.id = pos.get(i).get(j);
                        ww.gap = mini;
                        ((ArrayList)matrix.get(i)).add(ww);
                        ++j;
                    }
                }
                ++i;
            }
            int min = Integer.MAX_VALUE;
            int mini = 0;
            int i2 = 0;
            while (i2 < ((ArrayList)matrix.get(matrix.size() - 1)).size()) {
                if (min > ((Event)((ArrayList)matrix.get((int)(matrix.size() - 1))).get((int)i2)).ts) {
                    min = ((Event)((ArrayList)matrix.get((int)(matrix.size() - 1))).get((int)i2)).ts;
                    mini = i2;
                }
                ++i2;
            }
            if (min == Integer.MAX_VALUE) break;
            ArrayList<Integer> match = new ArrayList<Integer>();
            HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
            int i3 = matrix.size() - 1;
            while (i3 >= 0) {
                match.add(0, ((Event)((ArrayList)matrix.get((int)i3)).get((int)mini)).id);
                hm.put(((Event)((ArrayList)matrix.get((int)i3)).get((int)mini)).id, 1);
                mini = ((Event)((ArrayList)matrix.get((int)i3)).get((int)mini)).gap;
                --i3;
            }
            matches.add(match);
            i3 = 0;
            while (true) {
                if (i3 >= pos.size()) continue block0;
                Iterator<Integer> it = pos.get(i3).iterator();
                while (it.hasNext()) {
                    if (!hm.containsKey(it.next())) continue;
                    it.remove();
                }
                if (pos.get(i3).isEmpty()) {
                    return matches;
                }
                ++i3;
            }
            break;
        }
        return matches;
    }

    int gap_cost(ArrayList<ArrayList<Integer>> matches) {
        int g = 0;
        int i = 0;
        while (i < matches.size()) {
            int j = 1;
            while (j < matches.get(i).size()) {
                g += this.bits(matches.get(i).get(j) - matches.get(i).get(j - 1));
                ++j;
            }
            ++i;
        }
        return g;
    }

    void remove(ArrayList<ArrayList<Integer>> matches, int index) {
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < matches.size()) {
            int j = 0;
            while (j < matches.get(i).size()) {
                hm.put(matches.get(i).get(j), 1);
                ++j;
            }
            ++i;
        }
        Iterator<Event> it = this.data.get(index).iterator();
        while (it.hasNext()) {
            if (!hm.containsKey(it.next().ts)) continue;
            it.remove();
        }
    }

    ArrayList<Integer> getRelatedEvents(Integer e) {
        HashMap<Integer, SignTest> me = new HashMap<Integer, SignTest>();
        HashMap<Integer, Integer> mc = new HashMap<Integer, Integer>();
        ArrayList<Integer> nextdata = new ArrayList<Integer>();
        int i = 0;
        while (i < this.data.size()) {
            int next = this.data.get(i).size();
            int j = 0;
            while (j < this.data.get(i).size()) {
                if (this.data.get((int)i).get((int)j).id == e) {
                    next = j;
                    break;
                }
                ++j;
            }
            nextdata.add(++next);
            ++i;
        }
        i = 0;
        while (i < this.data.size()) {
            mc.clear();
            if ((Integer)nextdata.get(i) < this.data.get(i).size()) {
                double middle = this.data.get((int)i).get((int)((Integer)nextdata.get((int)i)).intValue()).ts;
                middle += ((double)this.data.get((int)i).get((int)(this.data.get((int)i).size() - 1)).ts - middle) / 2.0;
                int j = (Integer)nextdata.get(i);
                while (j < this.data.get(i).size()) {
                    if ((double)this.data.get((int)i).get((int)j).ts <= middle) {
                        if (!mc.containsKey(this.data.get((int)i).get((int)j).id)) {
                            mc.put(this.data.get((int)i).get((int)j).id, new Integer(1));
                        } else {
                            mc.put(this.data.get((int)i).get((int)j).id, new Integer((Integer)mc.get(this.data.get((int)i).get((int)j).id) + 1));
                        }
                    } else if (!mc.containsKey(this.data.get((int)i).get((int)j).id)) {
                        mc.put(this.data.get((int)i).get((int)j).id, new Integer(-1));
                    } else {
                        mc.put(this.data.get((int)i).get((int)j).id, new Integer((Integer)mc.get(this.data.get((int)i).get((int)j).id) - 1));
                    }
                    ++j;
                }
                for (Integer key : mc.keySet()) {
                    SignTest st;
                    if (!me.containsKey(key)) {
                        st = new SignTest(1, 0.0);
                        if ((Integer)mc.get(key) > 0) {
                            st.Nplus += 1.0;
                        }
                        me.put(key, st);
                        continue;
                    }
                    st = (Integer)mc.get(key) != 0 ? new SignTest(((SignTest)me.get((Object)key)).Npairs + 1, ((SignTest)me.get((Object)key)).Nplus) : new SignTest(((SignTest)me.get((Object)key)).Npairs, ((SignTest)me.get((Object)key)).Nplus);
                    if ((Integer)mc.get(key) > 0) {
                        st.Nplus += 1.0;
                    }
                    me.put(key, st);
                }
            }
            ++i;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Integer key : me.keySet()) {
            if (((SignTest)me.get(key)).sign_test()) {
                results.add(key);
            }
            if (results.size() > 1000) break;
        }
        return results;
    }

    int bits(Integer a) {
        if (a < 0) {
            return 0;
        }
        double x = Math.log(a.intValue()) / Math.log(2.0);
        return 2 * this.lowround(x) + 1;
    }

    int lowround(double x) {
        int y = (int)Math.round(x);
        if ((double)y > x) {
            --y;
        }
        return y;
    }

    boolean isOccurred(MyPattern p, int index) {
        int d = 0;
        int i = 0;
        while (i < this.data.get(index).size() && d < p.ids.size()) {
            if (p.ids.get(d) == this.data.get((int)index).get((int)i).id) {
                ++d;
            }
            ++i;
        }
        return d == p.ids.size();
    }

    void printData() {
        int i = 0;
        while (i < this.data.size()) {
            int j = 0;
            while (j < this.data.get(i).size()) {
                System.out.print(String.valueOf(this.data.get((int)i).get((int)j).id + 1) + " -1 ");
                ++j;
            }
            System.out.print("-2");
            System.out.println();
            ++i;
        }
    }

    void printMyPattern(MyPattern pattern) throws IOException {
        if (this.writer == null) {
            if (this.labels == null || this.labels.isEmpty()) {
                System.out.print("");
                int j = 0;
                while (j < pattern.ids.size()) {
                    System.out.print(pattern.ids.get(j) + " ");
                    ++j;
                }
                System.out.println(" #SUP: " + pattern.ben);
            } else {
                System.out.print("");
                int j = 0;
                while (j < pattern.ids.size()) {
                    System.out.print(String.valueOf(this.labels.get(pattern.ids.get(j))) + " ");
                    ++j;
                }
                System.out.println(" #SUP: " + pattern.ben);
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            if (this.labels == null || this.labels.isEmpty()) {
                int j = 0;
                while (j < pattern.ids.size()) {
                    this.writer.write(pattern.ids.get(j) + " ");
                    ++j;
                }
                this.writer.write(" #SUP: " + pattern.ben);
            } else {
                int j = 0;
                while (j < pattern.ids.size()) {
                    this.writer.write(String.valueOf(this.labels.get(pattern.ids.get(j))) + " ");
                    ++j;
                }
                this.writer.write(" #SUP: " + pattern.ben);
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void setOutputFilePath(String outputFilePath) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
    }
}

