/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MDPattern {
    List<Integer> values = new ArrayList<Integer>();
    public static final int WILDCARD = 9999;
    private int id;
    protected Set<Integer> patternsID = null;

    public MDPattern(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int size() {
        return this.values.size();
    }

    public int getValue(int index) {
        return this.values.get(index);
    }

    public Integer get(int index) {
        return this.values.get(index);
    }

    public void addInteger(int value) {
        this.values.add(value);
    }

    public void addWildCard() {
        this.values.add(9999);
    }

    public void addIntegerFirstPosition(int value) {
        this.values.add(0, value);
    }

    public void addWildCardFirstPosition() {
        this.values.add(0, 9999);
    }

    public double getRelativeSupport(int databaseSize) {
        return (double)this.patternsID.size() / (double)databaseSize;
    }

    public int getAbsoluteSupport() {
        if (this.patternsID == null) {
            return 0;
        }
        return this.patternsID.size();
    }

    public String getRelativeSupportFormatted(int databaseSize) {
        double support = (double)this.getAbsoluteSupport() / (double)databaseSize;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(support);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuffer r = new StringBuffer("[ ");
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.get(i).equals(9999)) {
                r.append("* ");
            } else {
                r.append(this.values.get(i));
                r.append(' ');
            }
            ++i;
        }
        r.append(']');
        if (this.getPatternsID() != null) {
            r.append("  Patterns ID: ");
            for (Integer id : this.getPatternsID()) {
                r.append(id);
                r.append(' ');
            }
        }
        r.append("   ");
        return r.toString();
    }

    public String toStringShort() {
        StringBuffer r = new StringBuffer("[ ");
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.get(i).equals(9999)) {
                r.append("* ");
            } else {
                r.append(this.values.get(i));
                r.append(' ');
            }
            ++i;
        }
        r.append(']');
        return r.toString();
    }

    public Set<Integer> getPatternsID() {
        return this.patternsID;
    }

    public void setPatternsIDList(Set<Integer> patternsID) {
        this.patternsID = patternsID;
    }

    public int strictlyContains(MDPattern mdpattern2) {
        if (this.getAbsoluteSupport() != mdpattern2.getAbsoluteSupport()) {
            return 0;
        }
        boolean allthesame = true;
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.get(i).intValue() != mdpattern2.getValue(i)) {
                allthesame = false;
            }
            if (this.values.get(i) != 9999 && this.values.get(i).intValue() != mdpattern2.getValue(i)) {
                return 0;
            }
            ++i;
        }
        if (allthesame) {
            return 2;
        }
        return 1;
    }

    public void set(int indexDimension, int newValue) {
        this.values.remove(indexDimension);
        this.values.add(indexDimension, newValue);
    }

    public void setID(int id2) {
        this.id = id2;
    }
}

