/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.Abstraction_Generic;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.Abstraction_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.Pattern;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractionCreator_Qualitative
extends AbstractionCreator {
    private static AbstractionCreator_Qualitative instance = null;

    private AbstractionCreator_Qualitative() {
    }

    public static AbstractionCreator_Qualitative getInstance() {
        if (instance == null) {
            instance = new AbstractionCreator_Qualitative();
        }
        return instance;
    }

    @Override
    public Abstraction_Generic CreateDefaultAbstraction() {
        return Abstraction_Qualitative.crear(false);
    }

    public Abstraction_Generic createAbstraction(boolean equalRelation) {
        return Abstraction_Qualitative.crear(equalRelation);
    }

    private void addPair(Map<Pair, Pair> pairMap, Set<Pair> alreadyCountedForSequenceID, int id, Item item, boolean postfix) {
        Pair pair = new Pair(postfix, ItemAbstractionPairCreator.getInstance().getItemAbstractionPair(item, this.createAbstraction(postfix)));
        Pair oldPair = pairMap.get(pair);
        if (alreadyCountedForSequenceID.add(pair)) {
            if (oldPair == null) {
                pairMap.put(pair, pair);
            } else {
                pair = oldPair;
            }
            pair.getSequencesID().set(id);
        }
    }

    @Override
    public Set<Pair> findAllFrequentPairs(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> pairMap = new HashMap<Pair, Pair>();
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        for (PseudoSequence sequence : sequences) {
            alreadyCountedForSequenceID.clear();
            int k = 0;
            while (k < sequence.numberOfProjectionsIncluded()) {
                int i = 0;
                while (i < sequence.size(k)) {
                    int beginning;
                    if (k > 0 && i > 0) break;
                    Itemset itemset = sequence.getItemset(i, k);
                    int j = beginning = sequence.getBeginningOfItemset(k, i);
                    while (j < itemset.size()) {
                        Item item = itemset.get(j);
                        boolean postfix = sequence.isPostfix(k, i);
                        this.addPair(pairMap, alreadyCountedForSequenceID, sequence.getId(), item, postfix);
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
        }
        ArrayList sortedSet = new ArrayList(pairMap.keySet());
        Collections.sort(sortedSet);
        HashSet<Pair> s = new HashSet<Pair>();
        s.addAll(sortedSet);
        return s;
    }

    @Override
    public Map<Item, Set<Abstraction_Generic>> createAbstractions(Sequence sequence, Map<Item, BitSet> frequentItems) {
        return new HashMap<Item, Set<Abstraction_Generic>>();
    }

    @Override
    public Abstraction_Generic createAbstractionFromAPrefix(Pattern prefix, Abstraction_Generic abstraccion) {
        return abstraccion;
    }

    @Override
    public boolean isSubpattern(Pattern shorter, Pattern larger, int index, List<Integer> positions) {
        ItemAbstractionPair pair = shorter.getIthElement(index);
        Item itemPair = pair.getItem();
        Abstraction_Generic absPair = pair.getAbstraction();
        Abstraction_Generic previousAbs = index > 0 ? shorter.getIthElement(index - 1).getAbstraction() : null;
        boolean cancelled = false;
        Integer pos = null;
        while (positions.get(index) < larger.size()) {
            pos = index == 0 ? this.searchForFirstAppearance(larger, positions.get(index), itemPair) : this.findItemPositionInPattern(larger, itemPair, absPair, previousAbs, positions.get(index), positions.get(index - 1));
            if (pos != null) {
                positions.set(index, pos);
                if (index + 1 < shorter.size()) {
                    Integer newPos = this.increasePosition(positions.get(index));
                    positions.set(index + 1, newPos);
                    boolean output = this.isSubpattern(shorter, larger, index + 1, positions);
                    if (!output) continue;
                    return true;
                }
                return true;
            }
            if (index > 0) {
                int newPos = this.increaseItemset(larger, positions.get(index - 1));
                positions.set(index - 1, newPos);
            }
            cancelled = true;
            break;
        }
        if (index > 0 && !cancelled) {
            int newPos = this.increaseItemset(larger, positions.get(index - 1));
            positions.set(index - 1, newPos);
        }
        return false;
    }

    public Integer searchForFirstAppearance(Pattern p, Integer beginning, Item itemPair) {
        int i = beginning;
        while (i < p.size()) {
            Item currentItem = p.getIthElement(i).getItem();
            if (currentItem.equals(itemPair)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public Integer findItemPositionInPattern(Pattern p, Item itemPair, Abstraction_Generic currentAbs, Abstraction_Generic previousAbs, Integer currentPosition, Integer previousPosition) {
        Abstraction_Qualitative abs = (Abstraction_Qualitative)currentAbs;
        Integer pos = null;
        if (abs.hasEqualRelation()) {
            pos = this.searchForInTheSameItemset(p, itemPair, currentPosition);
        } else {
            int positionToSearchFor = currentPosition;
            if (!this.areInDifferentItemsets(p, previousPosition, currentPosition)) {
                positionToSearchFor = this.increaseItemset(p, currentPosition);
            }
            pos = this.searchForFirstAppearance(p, positionToSearchFor, itemPair);
        }
        return pos;
    }

    public Integer increasePosition(Integer beginning) {
        return beginning + 1;
    }

    public int increaseItemset(Pattern p, Integer beginning) {
        int i = beginning + 1;
        while (i < p.size()) {
            ItemAbstractionPair currentPair = p.getIthElement(i);
            Abstraction_Qualitative qualitativeAbs = (Abstraction_Qualitative)currentPair.getAbstraction();
            if (!qualitativeAbs.hasEqualRelation()) {
                return i;
            }
            ++i;
        }
        return p.size();
    }

    private Integer searchForInTheSameItemset(Pattern pattern, Item itemPair, Integer beginning) {
        int i = beginning;
        while (i < pattern.size()) {
            ItemAbstractionPair currentPair = pattern.getIthElement(i);
            Abstraction_Qualitative qualitativeAbstraction = (Abstraction_Qualitative)currentPair.getAbstraction();
            if (!qualitativeAbstraction.hasEqualRelation()) {
                return null;
            }
            if (currentPair.getItem().equals(itemPair)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    private boolean areInDifferentItemsets(Pattern pattern, Integer p1, Integer p2) {
        int i = p1 + 1;
        while (i <= p2 && i < pattern.size()) {
            ItemAbstractionPair currentPair = pattern.getIthElement(i);
            Abstraction_Qualitative qualitativeAbs = (Abstraction_Qualitative)currentPair.getAbstraction();
            if (!qualitativeAbs.hasEqualRelation()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

