/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PseudoSequence {
    private List<Long> timeShift = new ArrayList<Long>();
    private Sequence sequence;
    private List<Integer> firstItemset = new ArrayList<Integer>();
    private List<Integer> firstItem = new ArrayList<Integer>();

    public PseudoSequence(long timeShift, PseudoSequence pseudosequence, int itemsetIndex, int itemIndex, int firstItemset) {
        this.sequence = pseudosequence.sequence;
        long newTimeShift = timeShift + pseudosequence.timeShift.get(firstItemset);
        this.timeShift.add(newTimeShift);
        this.firstItemset.add(itemsetIndex + pseudosequence.firstItemset.get(firstItemset));
        if (this.firstItemset.get(0) == pseudosequence.firstItemset.get(firstItemset)) {
            this.firstItem.add(itemIndex + pseudosequence.firstItem.get(firstItemset));
        } else {
            this.firstItem.add(itemIndex);
        }
    }

    public PseudoSequence(long timeShift, Sequence sequence, int itemsetIndex, int itemIndex) {
        this.timeShift.add(timeShift);
        this.sequence = sequence;
        this.firstItemset.add(itemsetIndex);
        this.firstItem.add(itemIndex);
    }

    public void addProjectionPoint(int firstItemset, long timeShift, PseudoSequence pseudosequence, int itemsetIndex, int itemIndex) {
        long newTimeShift = timeShift + pseudosequence.timeShift.get(firstItemset);
        this.timeShift.add(newTimeShift);
        this.firstItemset.add(itemsetIndex + pseudosequence.firstItemset.get(firstItemset));
        if (this.firstItemset.get(this.firstItemset.size() - 1) == pseudosequence.firstItemset.get(firstItemset)) {
            this.firstItem.add(itemIndex + pseudosequence.firstItem.get(firstItemset));
        } else {
            this.firstItem.add(itemIndex);
        }
    }

    public int getFirstItemset(int index) {
        return this.firstItemset.get(index);
    }

    public int size(int i) {
        int size = this.sequence.size() - this.firstItemset.get(i);
        return size;
    }

    public int length(int firstItemset) {
        int itemsToNotBeTakenIntoAccount = 0;
        int i = 0;
        while (i < this.firstItemset.get(firstItemset)) {
            itemsToNotBeTakenIntoAccount += this.sequence.get(i).size();
            ++i;
        }
        return this.sequence.length() - (itemsToNotBeTakenIntoAccount += this.firstItem.get(firstItemset).intValue());
    }

    public int numberOfProjectionsIncluded() {
        return this.firstItemset.size();
    }

    public int getSizeOfItemsetAt(int firstItemset, int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset.get(firstItemset)).size();
        if (this.isFirstItemset(index)) {
            size -= this.firstItem.get(firstItemset).intValue();
        }
        return size;
    }

    public int getBeginningOfItemset(int firstItem, int itemsetIndex) {
        if (this.isFirstItemset(itemsetIndex)) {
            return this.firstItem.get(firstItem);
        }
        return 0;
    }

    public boolean isPostfix(int firstItem, int itemsetIndex) {
        return this.isFirstItemset(itemsetIndex) && this.firstItem.get(firstItem) != 0;
    }

    public boolean isFirstItemset(int index) {
        return index == 0;
    }

    public Item getItemAtInItemsetAt(int firstItem, int itemIndex, int itemsetIndex) {
        if (this.isFirstItemset(itemsetIndex)) {
            return this.getItemset(itemsetIndex, firstItem).get(itemIndex + this.firstItem.get(firstItem));
        }
        return this.getItemset(itemsetIndex, firstItem).get(itemIndex);
    }

    private long getTimeStamp(int itemsetIndex, int firstItemset) {
        return this.getItemset(itemsetIndex, firstItemset).getTimestamp() - this.timeShift.get(firstItemset);
    }

    public long getAbsoluteTimeStamp(int itemsetIndex, int firstItemset) {
        return this.getItemset(itemsetIndex, firstItemset).getTimestamp();
    }

    public long getRelativeTimeStamp(int itemsetIndex, int firstItemset) {
        return this.getTimeStamp(itemsetIndex, firstItemset);
    }

    public Itemset getItemset(int itemsetIndex, int firstitemset) {
        return this.sequence.get(itemsetIndex + this.firstItemset.get(firstitemset));
    }

    public int getId() {
        return this.sequence.getId();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        int k = 0;
        while (k < this.firstItemset.size()) {
            int i = 0;
            while (i < this.size(k)) {
                r.append("{t=");
                r.append(this.getTimeStamp(i, k));
                r.append(", ");
                int j = 0;
                while (j < this.getSizeOfItemsetAt(k, i)) {
                    r.append(this.getItemAtInItemsetAt(k, j, i).toString());
                    if (this.isPostfix(k, i)) {
                        r.append('*');
                    }
                    r.append(' ');
                    ++j;
                }
                r.append("}");
                ++i;
            }
            r.append("\n");
            ++k;
        }
        return r.toString();
    }

    public int indexOf(int firstItemset, int itemsetIndex, Item item) {
        Itemset itemset = this.getItemset(itemsetIndex, firstItemset);
        int beginning = this.getBeginningOfItemset(firstItemset, itemsetIndex);
        List<Item> items = itemset.getItems();
        int i = Collections.binarySearch(items, item);
        if (i >= beginning) {
            return i - beginning;
        }
        return -1;
    }

    public long getTimeShift(int firstItemset) {
        return this.timeShift.get(firstItemset);
    }
}

