/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.FrequentPatternEnumeration_ClaSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.Trie;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class AlgoClaSP {
    protected double minSupAbsolute;
    Saver saver = null;
    public long overallStart;
    public long overallEnd;
    protected long mainMethodStart;
    protected long mainMethodEnd;
    protected long postProcessingStart;
    protected long postProcessingEnd;
    protected Trie FrequentAtomsTrie;
    private AbstractionCreator abstractionCreator;
    private int numberOfFrequentPatterns;
    private boolean findClosedPatterns;
    private boolean executePruningMethods;
    public long joinCount;

    public AlgoClaSP(double minSupAbsolute, AbstractionCreator abstractionCreator, boolean findClosedPatterns, boolean executePruningMethods) {
        this.minSupAbsolute = minSupAbsolute;
        this.abstractionCreator = abstractionCreator;
        this.findClosedPatterns = findClosedPatterns;
        this.executePruningMethods = executePruningMethods;
    }

    public void runAlgorithm(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        MemoryLogger.getInstance().reset();
        this.overallStart = System.currentTimeMillis();
        this.claSP(database, (long)this.minSupAbsolute, keepPatterns, verbose, this.findClosedPatterns, this.executePruningMethods);
        this.overallEnd = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void claSP(SequenceDatabase database, long minSupAbsolute, boolean keepPatterns, boolean verbose, boolean findClosedPatterns, boolean executePruningMethods) {
        this.FrequentAtomsTrie = database.frequentItems();
        database.clear();
        database = null;
        FrequentPatternEnumeration_ClaSP frequentPatternEnumeration = new FrequentPatternEnumeration_ClaSP(this.abstractionCreator, minSupAbsolute, this.saver, findClosedPatterns, executePruningMethods);
        this.mainMethodStart = System.currentTimeMillis();
        frequentPatternEnumeration.dfsPruning(new Pattern(), this.FrequentAtomsTrie, verbose, null, null);
        this.mainMethodEnd = System.currentTimeMillis();
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
        if (verbose) {
            System.out.println("ClaSP: The algorithm takes " + (this.mainMethodEnd - this.mainMethodStart) / 1000L + " seconds and finds " + this.numberOfFrequentPatterns + " patterns");
        }
        if (findClosedPatterns) {
            List<Map.Entry<Pattern, Trie>> outputPatternsFromMainMethod = this.FrequentAtomsTrie.preorderTraversal(null);
            this.postProcessingStart = System.currentTimeMillis();
            frequentPatternEnumeration.removeNonClosedPatterns(outputPatternsFromMainMethod, keepPatterns);
            this.postProcessingEnd = System.currentTimeMillis();
            this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
            if (verbose) {
                System.out.println("ClaSP:The post-processing algorithm to remove the non-Closed patterns takes " + (this.postProcessingEnd - this.postProcessingStart) / 1000L + " seconds and finds " + this.numberOfFrequentPatterns + " Closed patterns");
            }
        } else if (keepPatterns) {
            List<Map.Entry<Pattern, Trie>> outputPatternsFromMainMethod = this.FrequentAtomsTrie.preorderTraversal(null);
            for (Map.Entry<Pattern, Trie> p : outputPatternsFromMainMethod) {
                this.saver.savePattern(p.getKey());
            }
        }
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
        frequentPatternEnumeration.clear();
        MemoryLogger.getInstance().checkMemory();
        this.joinCount = frequentPatternEnumeration.joinCount;
    }

    public String printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.getRunningTime());
        r.append(" ms\n");
        r.append(" Frequent sequences count : ");
        r.append(this.numberOfFrequentPatterns);
        r.append('\n');
        r.append(" Join count : ");
        r.append(this.joinCount);
        r.append('\n');
        r.append(" Max memory (mb):");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append(this.saver.print());
        r.append("\n===================================================\n");
        return r.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.overallEnd - this.overallStart;
    }

    public void clear() {
        this.FrequentAtomsTrie.removeAll();
        this.abstractionCreator = null;
    }

    public void showTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tree");
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree tree = new JTree(model);
        this.FrequentAtomsTrie.display(model, root);
        int i = 0;
        while (i < tree.getRowCount()) {
            tree.expandRow(i);
            ++i;
        }
        JFrame v = new JFrame();
        JScrollPane scroll = new JScrollPane(tree);
        v.getContentPane().add(scroll);
        v.pack();
        v.setVisible(true);
        v.setDefaultCloseOperation(3);
    }
}

