/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequence;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import java.util.ArrayList;
import java.util.List;

public class PseudoSequenceBIDE
extends PseudoSequence {
    int lastItemset;
    int lastItem;

    protected PseudoSequenceBIDE(PseudoSequenceBIDE sequence, int indexItemset, int indexItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = sequence.lastItemset;
        this.lastItem = sequence.lastItem;
    }

    protected PseudoSequenceBIDE(PseudoSequenceBIDE sequence, int indexItemset, int indexItem, int lastItemset, int lastItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = lastItemset;
        this.lastItem = lastItem;
    }

    public PseudoSequenceBIDE(Sequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence;
        this.firstItemset = indexItemset;
        this.firstItem = indexItem;
        this.lastItemset = sequence.size() - 1;
        this.lastItem = sequence.getItemsets().get(this.lastItemset).size() - 1;
    }

    protected int getLastItemPosition() {
        return this.lastItem - this.firstItem - 1;
    }

    @Override
    protected boolean isLastItemset(int index) {
        return index + this.firstItemset == this.lastItemset;
    }

    @Override
    public int getSizeOfItemsetAt(int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset).size();
        if (this.isLastItemset(index)) {
            size = 1 + this.lastItem;
        }
        if (this.isFirstItemset(index)) {
            size -= this.firstItem;
        }
        return size;
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            r.append("{");
            int j = 0;
            while (j < this.getSizeOfItemsetAt(i)) {
                if (!this.isLastItemset(i) || j <= this.lastItem) {
                    r.append(this.getItemAtInItemsetAt(j, i).toString());
                    if (this.isPostfix(i)) {
                        r.append('*');
                    }
                    r.append(' ');
                }
                ++j;
            }
            r.append("}");
            ++i;
        }
        r.append("  ");
        return r.toString();
    }

    @Override
    public int size() {
        int size = this.sequence.size() - this.firstItemset - (this.sequence.size() - 1 - this.lastItemset);
        if (size == 1 && this.sequence.getItemsets().get(this.firstItemset).size() == 0) {
            return 0;
        }
        return size;
    }

    protected boolean isCutAtRight(int index) {
        if (!this.isLastItemset(index)) {
            return false;
        }
        return this.sequence.getItemsets().get(index + this.firstItemset).size() - 1 != this.lastItem;
    }

    protected Position getIthLastInLastApearanceWithRespectToPrefix(List<Itemset> prefix, int i, PseudoSequencePair lastInstancePair) {
        int iditem = this.getIthItem(prefix, i);
        if (i == this.getItemOccurencesTotalCount(prefix) - 1) {
            int j = lastInstancePair.pseudoSequence.size() - 1;
            while (j >= 0) {
                int sizeItemsetJ = lastInstancePair.pseudoSequence.getItemset(j).size();
                int k = sizeItemsetJ - 1;
                while (k >= 0) {
                    int item = lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j);
                    if (item == iditem) {
                        return new Position(j, k);
                    }
                    if (item < iditem) break;
                    --k;
                }
                --j;
            }
        } else {
            Position LLiplus1 = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i + 1, lastInstancePair);
            int j = LLiplus1.itemset;
            while (j >= 0) {
                int k = lastInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if ((j != LLiplus1.itemset || k < LLiplus1.item) && lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j) == iditem) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        }
        return null;
    }

    protected PseudoSequenceBIDE getIthMaximumPeriodOfAPrefix(List<Itemset> prefix, int i) {
        PseudoSequencePair lastInstancePair = this.getLastInstanceOfPrefixSequenceNEW(prefix, this.getItemOccurencesTotalCount(prefix));
        Position ithlastlast = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i, lastInstancePair);
        if (i == 0) {
            return this.trimBeginingAndEnd(null, ithlastlast);
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequenceNEW(prefix, i);
        Position lastOfFirstInstance = firstInstance.list.get(i - 1);
        return this.trimBeginingAndEnd(lastOfFirstInstance, ithlastlast);
    }

    protected PseudoSequencePair getLastInstanceOfPrefixSequenceNEW(List<Itemset> prefix, int i) {
        int remainingToMatchFromPrefix = i;
        ArrayList<Position> listPositions = new ArrayList<Position>();
        int prefixItemsetPosition = prefix.size() - 1;
        int j = this.size() - 1;
        while (j >= 0) {
            int itemInPrefixPosition = prefix.get(prefixItemsetPosition).size() - 1;
            boolean allMatched = false;
            int searchedItem = prefix.get(prefixItemsetPosition).get(itemInPrefixPosition);
            ArrayList<Position> tempList = new ArrayList<Position>();
            int k = this.getSizeOfItemsetAt(j) - 1;
            while (k >= 0) {
                int currentItem = this.getItemAtInItemsetAt(k, j);
                if (currentItem == searchedItem) {
                    tempList.add(new Position(j, k));
                    if (--itemInPrefixPosition == -1 || tempList.size() == remainingToMatchFromPrefix) {
                        allMatched = true;
                        break;
                    }
                    searchedItem = prefix.get(prefixItemsetPosition).get(itemInPrefixPosition);
                } else if (currentItem < searchedItem) break;
                --k;
            }
            if (allMatched) {
                remainingToMatchFromPrefix -= tempList.size();
                listPositions.addAll(tempList);
                if (--prefixItemsetPosition == -1) {
                    return new PseudoSequencePair(this, listPositions);
                }
            }
            --j;
        }
        return null;
    }

    protected PseudoSequencePair getFirstInstanceOfPrefixSequenceNEW(List<Itemset> prefix, int i) {
        int remainingToMatchFromPrefix = i;
        ArrayList<Position> listPositions = new ArrayList<Position>();
        int prefixItemsetPosition = 0;
        int j = 0;
        while (j < this.size()) {
            int itemInPrefixPosition = 0;
            boolean allMatched = false;
            int searchedItem = prefix.get(prefixItemsetPosition).get(itemInPrefixPosition);
            ArrayList<Position> tempList = new ArrayList<Position>();
            int k = 0;
            while (k < this.getSizeOfItemsetAt(j) && !allMatched) {
                int currentItem = this.getItemAtInItemsetAt(k, j);
                if (currentItem == searchedItem) {
                    tempList.add(new Position(j, k));
                    if (++itemInPrefixPosition == prefix.get(prefixItemsetPosition).size() || tempList.size() == remainingToMatchFromPrefix) {
                        allMatched = true;
                        break;
                    }
                    searchedItem = prefix.get(prefixItemsetPosition).get(itemInPrefixPosition);
                } else if (currentItem > searchedItem) break;
                ++k;
            }
            if (allMatched) {
                remainingToMatchFromPrefix -= tempList.size();
                listPositions.addAll(tempList);
                if (++prefixItemsetPosition == prefix.size()) {
                    PseudoSequenceBIDE newSequence = new PseudoSequenceBIDE(this, this.firstItemset, this.firstItem, ((Position)listPositions.get((int)(i - 1))).itemset, ((Position)listPositions.get((int)(i - 1))).item);
                    return new PseudoSequencePair(newSequence, listPositions);
                }
            }
            ++j;
        }
        return null;
    }

    protected PseudoSequenceBIDE trimBeginingAndEnd(Position positionStart, Position positionEnd) {
        int itemsetStart = 0;
        int itemStart = 0;
        int itemsetEnd = this.lastItemset;
        int itemEnd = this.lastItem;
        if (positionStart != null) {
            itemStart = positionStart.item + 1;
            itemsetStart = positionStart.itemset;
            if (itemStart == this.getSizeOfItemsetAt(itemsetStart)) {
                ++itemsetStart;
                itemStart = 0;
            }
            if (itemsetStart == this.size()) {
                return null;
            }
        }
        if (positionEnd != null) {
            itemEnd = positionEnd.item - 1;
            itemsetEnd = positionEnd.itemset;
            if (itemEnd < 0) {
                itemsetEnd = positionEnd.itemset - 1;
                if (itemsetEnd < itemsetStart) {
                    return null;
                }
                itemEnd = this.getSizeOfItemsetAt(itemsetEnd) - 1;
            }
        }
        if (itemsetEnd == itemsetStart && itemEnd < itemStart) {
            return null;
        }
        return new PseudoSequenceBIDE(this, itemsetStart, itemStart, itemsetEnd, itemEnd);
    }

    public PseudoSequenceBIDE getIthSemiMaximumPeriodOfAPrefix(List<Itemset> prefix, int i) {
        PseudoSequencePair firstInstancePairNEW = this.getFirstInstanceOfPrefixSequenceNEW(prefix, this.getItemOccurencesTotalCount(prefix));
        Position ithlastfirst = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i, firstInstancePairNEW);
        if (i == 0) {
            return this.trimBeginingAndEnd(null, ithlastfirst);
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequenceNEW(prefix, i);
        Position endOfFirstInstance = firstInstance.list.get(i - 1);
        return this.trimBeginingAndEnd(endOfFirstInstance, ithlastfirst);
    }

    protected int getItemOccurencesTotalCount(List<Itemset> itemsets) {
        int count = 0;
        for (Itemset itemset : itemsets) {
            count += itemset.size();
        }
        return count;
    }

    protected Integer getIthItem(List<Itemset> itemsets, int i) {
        int j = 0;
        while (j < itemsets.size()) {
            if (i < itemsets.get(j).size()) {
                return itemsets.get(j).get(i);
            }
            i -= itemsets.get(j).size();
            ++j;
        }
        return null;
    }

    protected Position getIthLastInFirstApearanceWithRespectToPrefix(List<Itemset> prefix, int i, PseudoSequencePair firstInstancePair) {
        Integer iditem = this.getIthItem(prefix, i);
        if (i == this.getItemOccurencesTotalCount(prefix) - 1) {
            int j = firstInstancePair.pseudoSequence.size() - 1;
            while (j >= 0) {
                int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if (firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        } else {
            Position LLiplus1 = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i + 1, firstInstancePair);
            int j = LLiplus1.itemset;
            while (j >= 0) {
                int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if ((j != LLiplus1.itemset || k < LLiplus1.item) && firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        }
        return null;
    }

    protected static class Position {
        final int itemset;
        final int item;

        public Position(int itemset, int item) {
            this.itemset = itemset;
            this.item = item;
        }

        public String toString() {
            return "(" + this.itemset + "," + this.item + ")";
        }
    }

    protected static class PseudoSequencePair {
        final PseudoSequenceBIDE pseudoSequence;
        final List<Position> list;

        public PseudoSequencePair(PseudoSequenceBIDE pseudoSequence, List<Position> list) {
            this.pseudoSequence = pseudoSequence;
            this.list = list;
        }
    }
}

